/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.compat.ftbchunks.claimedchunksoverlay;

import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.data.ChunkSyncInfo;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.IOverlayListener;
import journeymap.api.v2.client.display.Overlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.fullscreen.IThemeButton;
import journeymap.api.v2.client.model.MapPolygonWithHoles;
import journeymap.api.v2.client.util.PolygonHelper;
import lombok.Generated;
import me.frankv.jmi.api.event.Event;
import me.frankv.jmi.api.jmoverlay.ClientConfig;
import me.frankv.jmi.api.jmoverlay.ToggleableOverlay;
import me.frankv.jmi.compat.ftbchunks.ClaimedChunk;
import me.frankv.jmi.compat.ftbchunks.FTBChunksCompatStates;
import me.frankv.jmi.compat.ftbchunks.OverlayUtil;
import me.frankv.jmi.compat.ftbchunks.PolygonWrapper;
import me.frankv.jmi.compat.ftbchunks.claimedchunksoverlay.ClaimedChunkOverlayListener;
import me.frankv.jmi.compat.ftbchunks.claimingmode.ClaimingMode;
import me.frankv.jmi.util.OverlayHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ClaimedChunksOverlay implements ToggleableOverlay
{
    INSTANCE;

    @Generated
    private static final Logger log;
    private final Minecraft mc = Minecraft.getInstance();
    private final Queue<ClaimedChunk> queue = new LinkedList<ClaimedChunk>();
    private final int order = 1;
    private final String buttonLabel = "jmi.toggleable_overlay.ftbchunks";
    private ClientConfig clientConfig;
    private boolean activated = true;
    private int tick = 1;
    private FTBChunksCompatStates states;
    private boolean shouldToggleAfterOff = false;
    private boolean jmMappingStarted = false;

    public void init(ClientConfig clientConfig, FTBChunksCompatStates states) {
        this.clientConfig = clientConfig;
        this.states = states;
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::onTeamPropsChanged);
    }

    public void onClientTick() {
        if (!this.clientConfig.getFtbChunks().booleanValue()) {
            return;
        }
        if (this.mc.level == null) {
            return;
        }
        if (!this.jmMappingStarted) {
            return;
        }
        if (this.tick < 0 || this.tick % 4 != 0) {
            ++this.tick;
            return;
        }
        HashSet<UUID> modifiedTeamIds = new HashSet<UUID>();
        for (ClaimedChunk data : this.queue) {
            if (data.getTeam().isEmpty()) {
                ClaimedChunk removed = this.states.getChunkData().remove(data.chunkDimPos());
                Optional.ofNullable(removed).ifPresentOrElse(o -> modifiedTeamIds.add(o.teamId()), () -> log.warn("Failed to remove an unknown claimed chunk. dim: {}, chunk: {}, player_dim: {}", new Object[]{data.chunkDimPos().dimension(), data.chunkDimPos().chunkPos(), this.mc.level.dimension()}));
                continue;
            }
            ClaimedChunk existent = this.states.getChunkData().get(data.chunkDimPos());
            if (existent != null) {
                modifiedTeamIds.add(existent.teamId());
                this.replaceChunk(data);
            } else {
                this.states.getChunkData().put(data.chunkDimPos(), data);
            }
            modifiedTeamIds.add(data.teamId());
        }
        if (!modifiedTeamIds.isEmpty()) {
            Map<UUID, Set<PolygonWrapper>> polygon = this.createPolygon((Level)this.mc.level, modifiedTeamIds);
            modifiedTeamIds.forEach(id -> this.updateOverlays((UUID)id, polygon.getOrDefault(id, Set.of())));
        }
        this.queue.clear();
        this.tick = 1;
    }

    public void showForceLoadedByArea(boolean show) {
        ClientLevel level = this.mc.level;
        if (level == null) {
            return;
        }
        if (!show) {
            OverlayHelper.removeOverlays(this.states.getForceLoadedOverlays().values());
            this.states.getForceLoadedOverlays().clear();
            return;
        }
        ClaimingMode.INSTANCE.getArea().forEach(p -> {
            ChunkDimPos chunkDimPos = new ChunkDimPos(level.dimension(), p.x, p.z);
            this.showForceLoaded(chunkDimPos, true);
        });
    }

    public void onClaiming(boolean off) {
        if (!off && this.activated) {
            return;
        }
        if (!off) {
            this.toggleOverlay();
            this.shouldToggleAfterOff = true;
        } else if (this.shouldToggleAfterOff) {
            this.toggleOverlay();
            this.shouldToggleAfterOff = false;
        }
    }

    private Map<UUID, Set<PolygonWrapper>> createPolygon(Level level) {
        return this.createPolygon(level, null);
    }

    private Map<UUID, Set<PolygonWrapper>> createPolygon(Level level, Set<UUID> teamIds) {
        HashMap pos = new HashMap();
        HashMap<UUID, Set<PolygonWrapper>> overlays = new HashMap<UUID, Set<PolygonWrapper>>();
        this.states.getChunkData().values().stream().filter(data -> data.chunkDimPos().dimension().equals(level.dimension())).filter(o -> teamIds == null || teamIds.contains(o.teamId())).forEach(o -> pos.computeIfAbsent(o.teamId(), k -> new HashSet()).add(o.chunkDimPos().chunkPos()));
        for (UUID teamId : pos.keySet()) {
            List polygons = PolygonHelper.createChunksPolygon((Collection)((Collection)pos.get(teamId)), (int)10);
            ClientTeam team = ClientTeamManagerImpl.getInstance().getTeam(teamId).orElse(null);
            if (team == null) continue;
            for (MapPolygonWithHoles polygon : polygons) {
                PolygonOverlay overlay = new PolygonOverlay("jmi", level.dimension(), this.states.getShapeProps(team, this.clientConfig.getClaimedChunkOverlayOpacity().floatValue()), polygon);
                overlay.setOverlayGroupName("Claimed Chunks").setTitle(team.getDisplayName()).setOverlayListener((IOverlayListener)new ClaimedChunkOverlayListener(teamId, this.states, overlay)).setTextProperties(this.states.getTextProps(team));
                overlays.computeIfAbsent(teamId, k -> new HashSet()).add(new PolygonWrapper(overlay));
            }
        }
        return overlays;
    }

    private void updateOverlays(UUID teamId, Set<PolygonWrapper> newOverlays) {
        Set oldOverlays = Set.copyOf(this.states.getTeamOverlays().getOrDefault(teamId, Set.of()));
        if (oldOverlays.isEmpty()) {
            this.states.getTeamOverlays().put(teamId, newOverlays);
            if (!this.activated) {
                return;
            }
            newOverlays.forEach(o -> OverlayHelper.showOverlay((Displayable)o.polygon()));
            return;
        }
        HashSet<PolygonWrapper> addOverlays = new HashSet<PolygonWrapper>(newOverlays);
        HashSet rmvOverlays = new HashSet(oldOverlays);
        rmvOverlays.removeAll(newOverlays);
        addOverlays.removeAll(oldOverlays);
        HashSet<PolygonWrapper> newSet = new HashSet<PolygonWrapper>(oldOverlays);
        newSet.removeAll(rmvOverlays);
        newSet.addAll(addOverlays);
        this.states.getTeamOverlays().put(teamId, newSet);
        if (!this.activated) {
            return;
        }
        rmvOverlays.forEach(o -> OverlayHelper.removeOverlay((Displayable)o.polygon()));
        addOverlays.forEach(o -> OverlayHelper.showOverlay((Displayable)o.polygon()));
    }

    private void replaceChunk(ClaimedChunk data) {
        this.states.getChunkData().remove(data.chunkDimPos());
        this.states.getChunkData().put(data.chunkDimPos(), data);
        if (!ClaimingMode.INSTANCE.isActivated()) {
            return;
        }
        this.showForceLoaded(data.chunkDimPos(), false);
        this.showForceLoaded(data.chunkDimPos(), true);
    }

    private void showForceLoaded(ChunkDimPos chunkDimPos, boolean show) {
        if (!this.states.getChunkData().containsKey(chunkDimPos)) {
            return;
        }
        ClaimedChunk data = this.states.getChunkData().get(chunkDimPos);
        if (show && data.forceLoaded() && !this.states.getForceLoadedOverlays().containsKey(chunkDimPos)) {
            Overlay claimedOverlay = ClaimingMode.INSTANCE.forceLoadedPolygon(chunkDimPos, data, this.states);
            OverlayHelper.showOverlay((Displayable)claimedOverlay);
            this.states.getForceLoadedOverlays().put(chunkDimPos, claimedOverlay);
        } else if (!show && this.states.getForceLoadedOverlays().containsKey(chunkDimPos)) {
            OverlayHelper.removeOverlay((Displayable)this.states.getForceLoadedOverlays().get(chunkDimPos));
            this.states.getForceLoadedOverlays().remove(chunkDimPos);
        }
    }

    private void onTeamPropsChanged(ClientTeamPropertiesChangedEvent event) {
        Team team = event.getTeam();
        ClientTeam clientTeam = ClientTeamManagerImpl.getInstance().getTeam(team.getTeamId()).orElse(null);
        if (clientTeam == null) {
            return;
        }
        String oldName = (String)event.getOldProperties().get((TeamProperty)TeamProperties.DISPLAY_NAME);
        boolean nameChanged = !Objects.equals(oldName, team.getName().getString());
        Optional.ofNullable(this.states.getShapeProperties().get(team.getTeamId())).ifPresent(prop -> prop.setFillColor(clientTeam.getColor()).setStrokeColor(clientTeam.getColor()));
        Optional.ofNullable(this.states.getTextProperties().get(team.getTeamId())).ifPresent(prop -> prop.setColor(OverlayUtil.getTeamTextColor(clientTeam)));
        if (!nameChanged) {
            return;
        }
        Optional.ofNullable(this.states.getTeamOverlays().get(team.getTeamId())).orElse(Collections.emptySet()).forEach(overlay -> {
            overlay.polygon().setTitle(clientTeam.getDisplayName());
            OverlayHelper.removeOverlay((Displayable)overlay.polygon());
            OverlayHelper.showOverlay((Displayable)overlay.polygon());
        });
    }

    @Override
    public void onToggle(IThemeButton button) {
        if (ClaimingMode.INSTANCE.isActivated()) {
            return;
        }
        this.toggleOverlay();
        button.setToggled(Boolean.valueOf(this.activated));
    }

    private void toggleOverlay() {
        Consumer<Displayable> action = this.activated ? OverlayHelper::removeOverlay : OverlayHelper::showOverlay;
        this.states.getTeamOverlays().values().stream().flatMap(Collection::stream).map(PolygonWrapper::polygon).forEach(action);
        this.activated = !this.activated;
    }

    private void createPolygonsOnMappingStarted() {
        ClientLevel level = this.mc.level;
        if (level == null) {
            return;
        }
        if (!this.activated) {
            return;
        }
        this.createPolygon((Level)level).forEach(this::updateOverlays);
    }

    public void onJMMapping(Event.JMMappingEvent e) {
        switch (e.mappingEvent().getStage()) {
            case MAPPING_STARTED: {
                this.tick = -20;
                this.jmMappingStarted = true;
                if (e.firstLogin()) break;
                this.createPolygonsOnMappingStarted();
                log.debug("re-add ftbchunks overlays");
                break;
            }
            case MAPPING_STOPPED: {
                this.jmMappingStarted = false;
                this.states.clearOverlays();
            }
        }
    }

    public void addToQueue(MapDimension dim, ChunkSyncInfo info, UUID teamId) {
        if (!this.clientConfig.getFtbChunks().booleanValue()) {
            return;
        }
        this.queue.offer(ClaimedChunk.create(dim, info, teamId));
        this.tick = this.tick > 0 ? 1 : -20;
    }

    @Override
    public ResourceLocation getButtonIconName() {
        return ResourceLocation.fromNamespaceAndPath((String)"jmi", (String)"images/ftb.png");
    }

    @Override
    @Generated
    public int getOrder() {
        return this.order;
    }

    @Override
    @Generated
    public String getButtonLabel() {
        return this.buttonLabel;
    }

    @Override
    @Generated
    public boolean isActivated() {
        return this.activated;
    }

    static {
        log = LoggerFactory.getLogger(ClaimedChunksOverlay.class);
    }
}

