/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.api;

import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.fullscreen.ThemeButtonDisplay;
import lombok.Generated;
import me.frankv.jmi.api.ModCompat;
import me.frankv.jmi.api.event.Event;
import me.frankv.jmi.api.event.JMIEventBus;
import me.frankv.jmi.api.jmoverlay.ClientConfig;
import me.frankv.jmi.api.jmoverlay.ToggleableOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModCompatFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModCompatFactory.class);
    private final Map<Class<? extends ModCompat>, ModCompat> modCompatMap = ServiceLoader.load(ModCompat.class).stream().map(provider -> {
        try {
            return (ModCompat)provider.get();
        }
        catch (Error | Exception e) {
            log.warn("Failed to init JMI mod compat {}", (Object)e.getLocalizedMessage(), (Object)e);
            return null;
        }
    }).filter(Objects::nonNull).filter(ModCompat::isTargetModsLoaded).collect(Collectors.toUnmodifiableMap((Function<ModCompat, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lme/frankv/jmi/api/ModCompat;)Ljava/lang/Class;)(), Function.identity()));

    public ModCompatFactory(IClientAPI jmAPI, ClientConfig clientConfig, JMIEventBus eventBus) {
        this.modCompatMap.values().forEach(compat -> {
            compat.init(jmAPI, clientConfig);
            compat.registerEvent(eventBus);
        });
        eventBus.subscribe(Event.AddButtonDisplay.class, this::onAddButtonDisplay);
    }

    public <T extends ModCompat> T get(Class<T> clazz) {
        return (T)((ModCompat)Optional.ofNullable(this.modCompatMap.get(clazz)).map(clazz::cast).orElse(null));
    }

    private void onAddButtonDisplay(Event.AddButtonDisplay event) {
        ThemeButtonDisplay themeButtonDisplay = event.themeButtonDisplay();
        this.modCompatMap.values().stream().flatMap(modCompat -> modCompat.getToggleableOverlays().stream()).sorted(Comparator.comparing(ToggleableOverlay::getOrder)).forEach(t -> themeButtonDisplay.addThemeToggleButton(t.getButtonLabel(), t.getButtonLabel(), t.getButtonIconName(), t.isActivated(), t::onToggle));
    }
}

