/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge;

import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntitySpawnEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;

public class TropicraftCompat
implements ModCompat {
    protected static Optional<EntityType<?>> TROPIBEE;

    public TropicraftCompat() {
        TROPIBEE = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.fromNamespaceAndPath((String)"tropicraft", (String)"tropibee"));
        ModChecker.tropicraftPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.SPAWNS);
    }

    @Override
    public boolean onBeeSpawn(BzEntitySpawnEvent event, boolean isChild) {
        if (!BzModCompatibilityConfigs.spawnTropicraftBeesMob || TROPIBEE.isEmpty()) {
            return false;
        }
        if ((double)event.entity().getRandom().nextFloat() >= BzModCompatibilityConfigs.spawnrateOfTropicraftBeesMobs) {
            return false;
        }
        if (event.spawnType() == MobSpawnType.DISPENSER && !BzModCompatibilityConfigs.allowTropicraftSpawnFromDispenserFedBroodBlock) {
            return false;
        }
        Mob entity = event.entity();
        LevelAccessor world = event.level();
        Entity newEntity = TROPIBEE.get().create(entity.level());
        if (!(newEntity instanceof Mob)) {
            return false;
        }
        Mob tropibee = (Mob)newEntity;
        tropibee.moveTo(entity.getX(), entity.getY(), entity.getZ(), tropibee.getRandom().nextFloat() * 360.0f, 0.0f);
        tropibee.setBaby(isChild);
        world.addFreshEntity((Entity)tropibee);
        return true;
    }
}

