/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.menus;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.CrystallineFlowerBlockEntity;
import com.telepathicgrunt.the_bumblezone.blocks.datamanagers.CrystallineFlowerDataManager;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.menus.EnchantmentSkeleton;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.CrystallineFlowerEnchantmentPacket;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;

public class CrystallineFlowerMenu
extends AbstractContainerMenu {
    public static final int CONSUME_SLOT = 0;
    private static final int BOOK_SLOT = 1;
    private static final int ENCHANTED_SLOT = 2;
    public static final int CONSUME_SLOT_X = 47;
    public static final int CONSUME_SLOT_Y = 80;
    private static final int BOOK_SLOT_X = 92;
    private static final int BOOK_SLOT_Y = 28;
    private static final int ENCHANTED_SLOT_X = 136;
    private static final int ENCHANTED_SLOT_Y = 28;
    private final ContainerLevelAccess access;
    private final Player player;
    public final CrystallineFlowerBlockEntity crystallineFlowerBlockEntity;
    public final Slot consumeSlot;
    public final Slot bookSlot;
    public final Slot enchantedSlot;
    public ResourceLocation selectedEnchantment = null;
    public final DataSlot xpBarPercent = DataSlot.standalone();
    public final DataSlot xpTier = DataSlot.standalone();
    public final DataSlot tierCostUpper = DataSlot.standalone();
    public final DataSlot tierCostLower = DataSlot.standalone();
    public final DataSlot bottomBlockPosXUpper = DataSlot.standalone();
    public final DataSlot bottomBlockPosXLower = DataSlot.standalone();
    public final DataSlot bottomBlockPosYUpper = DataSlot.standalone();
    public final DataSlot bottomBlockPosYLower = DataSlot.standalone();
    public final DataSlot bottomBlockPosZUpper = DataSlot.standalone();
    public final DataSlot bottomBlockPosZLower = DataSlot.standalone();
    public final DataSlot playerHasXPForTier = DataSlot.standalone();
    public final DataSlot consumeSlotFullyObstructed = DataSlot.standalone();
    public final DataSlot tooManyEnchantmentsOnInput = DataSlot.standalone();
    private final Container inputContainer = new SimpleContainer(3){

        public void setChanged() {
            super.setChanged();
            CrystallineFlowerMenu.this.slotsChanged((Container)this);
        }
    };
    long lastSoundTime;

    public CrystallineFlowerMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL, null);
    }

    public CrystallineFlowerMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access, final CrystallineFlowerBlockEntity crystallineFlowerBlockEntity) {
        super((MenuType)BzMenuTypes.CRYSTALLINE_FLOWER.get(), containerId);
        int i;
        this.access = access;
        this.player = playerInventory.player;
        this.crystallineFlowerBlockEntity = crystallineFlowerBlockEntity;
        this.consumeSlot = this.addSlot(new Slot(this.inputContainer, 0, 47, 80){

            public boolean mayPlace(ItemStack itemStack) {
                EntityBlock entityBlock;
                BlockItem blockItem;
                if (!BzGeneralConfigs.crystallineFlowerConsumeItemUI) {
                    return false;
                }
                if (CrystallineFlowerDataManager.CRYSTALLINE_FLOWER_DATA_MANAGER.disallowConsume.contains(itemStack.getItem())) {
                    return false;
                }
                if (!itemStack.getItem().canFitInsideContainerItems()) {
                    return false;
                }
                Item item = itemStack.getItem();
                return !(item instanceof BlockItem) || !((item = (blockItem = (BlockItem)item).getBlock()) instanceof EntityBlock) || !((entityBlock = (EntityBlock)item).newBlockEntity(BlockPos.ZERO, blockItem.getBlock().defaultBlockState()) instanceof Container);
            }

            public void setChanged() {
                this.container.setChanged();
                CrystallineFlowerMenu.this.consumeSlotFullyObstructed();
                if (!CrystallineFlowerMenu.this.player.level().isClientSide()) {
                    crystallineFlowerBlockEntity.setConsumeSlotItems(CrystallineFlowerMenu.this.consumeSlot.getItem());
                    crystallineFlowerBlockEntity.syncPillar();
                }
            }
        });
        this.bookSlot = this.addSlot(new Slot(this.inputContainer, 1, 92, 28){

            public boolean mayPlace(ItemStack itemStack) {
                return itemStack.is(BzTags.CAN_BE_ENCHANTED_ITEMS);
            }

            public void setChanged() {
                this.container.setChanged();
                ItemStack bookSlotItem = CrystallineFlowerMenu.this.bookSlot.getItem();
                if (bookSlotItem.isEmpty()) {
                    CrystallineFlowerMenu.this.selectedEnchantment = null;
                }
                if (!CrystallineFlowerMenu.this.player.level().isClientSide()) {
                    CrystallineFlowerMenu.this.setupResultSlot();
                    CrystallineFlowerMenu.this.broadcastChanges();
                    crystallineFlowerBlockEntity.setBookSlotItems(CrystallineFlowerMenu.this.bookSlot.getItem());
                    crystallineFlowerBlockEntity.syncPillar();
                }
            }
        });
        this.enchantedSlot = this.addSlot(new Slot(this.inputContainer, 2, 136, 28){

            public boolean mayPlace(ItemStack itemStack) {
                return false;
            }

            public void onTake(Player player, ItemStack itemStack) {
                access.execute((soundLevel, pos) -> {
                    long gameTime = soundLevel.getGameTime();
                    if (CrystallineFlowerMenu.this.lastSoundTime != gameTime) {
                        soundLevel.playSound(null, pos, (SoundEvent)BzSounds.CRYSTALLINE_FLOWER_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        CrystallineFlowerMenu.this.lastSoundTime = gameTime;
                    }
                });
                ItemStack oldConsumeStack = CrystallineFlowerMenu.this.bookSlot.getItem().copy();
                Map<ResourceLocation, EnchantmentInstance> oldAvailableEnchantments = CrystallineFlowerMenu.this.getAvailableEnchantments(player.level(), oldConsumeStack);
                CrystallineFlowerMenu.this.bookSlot.remove(1);
                CrystallineFlowerMenu.this.drainFlowerXPLevel(GeneralUtils.merge(CrystallineFlowerMenu.this.tierCostUpper.get(), CrystallineFlowerMenu.this.tierCostLower.get()));
                if (!player.level().isClientSide()) {
                    EnchantmentInstance oldEnchantSelected = oldAvailableEnchantments.get(CrystallineFlowerMenu.this.selectedEnchantment);
                    CrystallineFlowerMenu.this.selectedEnchantment = null;
                    CrystallineFlowerMenu.this.setupResultSlot(((ResourceKey)oldEnchantSelected.enchantment.unwrapKey().get()).location());
                    CrystallineFlowerMenu.this.broadcastChanges();
                    crystallineFlowerBlockEntity.setBookSlotItems(CrystallineFlowerMenu.this.bookSlot.getItem());
                    crystallineFlowerBlockEntity.syncPillar();
                } else {
                    CrystallineFlowerMenu.this.selectedEnchantment = null;
                }
                super.onTake(player, itemStack);
            }
        });
        int playerInvYOffset = 115;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, playerInvYOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, playerInvYOffset + 58));
        }
        this.selectedEnchantment = null;
        this.xpBarPercent.set(0);
        this.xpTier.set(0);
        this.tierCostUpper.set(0);
        this.tierCostLower.set(0);
        this.playerHasXPForTier.set(0);
        this.consumeSlotFullyObstructed.set(0);
        this.tooManyEnchantmentsOnInput.set(0);
        this.bottomBlockPosXUpper.set(0);
        this.bottomBlockPosXLower.set(0);
        this.bottomBlockPosYUpper.set(0);
        this.bottomBlockPosYLower.set(0);
        this.bottomBlockPosZUpper.set(0);
        this.bottomBlockPosZLower.set(0);
        if (this.crystallineFlowerBlockEntity != null) {
            this.bottomBlockPosXUpper.set(GeneralUtils.split(this.crystallineFlowerBlockEntity.getBlockPos().getX(), true));
            this.bottomBlockPosXLower.set(GeneralUtils.split(this.crystallineFlowerBlockEntity.getBlockPos().getX(), false));
            this.bottomBlockPosYUpper.set(GeneralUtils.split(this.crystallineFlowerBlockEntity.getBlockPos().getY(), true));
            this.bottomBlockPosYLower.set(GeneralUtils.split(this.crystallineFlowerBlockEntity.getBlockPos().getY(), false));
            this.bottomBlockPosZUpper.set(GeneralUtils.split(this.crystallineFlowerBlockEntity.getBlockPos().getZ(), true));
            this.bottomBlockPosZLower.set(GeneralUtils.split(this.crystallineFlowerBlockEntity.getBlockPos().getZ(), false));
        }
        this.syncXpTier();
        this.addDataSlot(this.xpBarPercent);
        this.addDataSlot(this.xpTier);
        this.addDataSlot(this.tierCostUpper);
        this.addDataSlot(this.tierCostLower);
        this.addDataSlot(this.playerHasXPForTier);
        this.addDataSlot(this.consumeSlotFullyObstructed);
        this.addDataSlot(this.tooManyEnchantmentsOnInput);
        this.addDataSlot(this.bottomBlockPosXUpper);
        this.addDataSlot(this.bottomBlockPosXLower);
        this.addDataSlot(this.bottomBlockPosYUpper);
        this.addDataSlot(this.bottomBlockPosYLower);
        this.addDataSlot(this.bottomBlockPosZUpper);
        this.addDataSlot(this.bottomBlockPosZLower);
        if (this.crystallineFlowerBlockEntity != null) {
            this.bookSlot.set(this.crystallineFlowerBlockEntity.getBookSlotItems());
            this.consumeSlot.set(this.crystallineFlowerBlockEntity.getConsumeSlotItems());
            this.broadcastChanges();
        }
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        this.setupResultSlot();
    }

    private void syncXpTier() {
        if (this.crystallineFlowerBlockEntity != null) {
            int currentXP = this.crystallineFlowerBlockEntity.getCurrentXp();
            int maxXPForCurrentTier = this.crystallineFlowerBlockEntity.getMaxXpForTier(this.crystallineFlowerBlockEntity.getXpTier());
            this.xpBarPercent.set((int)((float)currentXP / (float)maxXPForCurrentTier * 100.0f));
            this.xpTier.set(this.crystallineFlowerBlockEntity.getXpTier());
            if (this.player.getAbilities().instabuild) {
                this.playerHasXPForTier.set(Math.min(7 - this.crystallineFlowerBlockEntity.getXpTier(), 3));
            } else {
                int tierAbleToBeBought = 0;
                int totalXPRequires = 0;
                long playerXP = EnchantmentUtils.getPlayerXP(this.player);
                for (int i = 0; i < 3; ++i) {
                    if (this.crystallineFlowerBlockEntity.getXpTier() + i >= 7) continue;
                    totalXPRequires += this.crystallineFlowerBlockEntity.getMaxXpForTier(this.crystallineFlowerBlockEntity.getXpTier() + i);
                    if (i == 0) {
                        totalXPRequires -= currentXP;
                    }
                    if ((long)totalXPRequires > playerXP) break;
                    ++tierAbleToBeBought;
                }
                this.playerHasXPForTier.set(tierAbleToBeBought);
            }
            this.broadcastChanges();
        }
    }

    public void slotsChanged(Container inventory) {
    }

    public boolean clickMenuEnchantment(Player player, ResourceLocation selectedEnchant) {
        this.selectedEnchantment = selectedEnchant;
        if (!player.level().isClientSide()) {
            this.setupResultSlot();
            this.broadcastChanges();
        }
        return true;
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == -2) {
            this.drainPlayerXPLevel(1);
            if (!player.level().isClientSide()) {
                this.setupResultSlot();
                this.broadcastChanges();
            }
            return true;
        }
        if (id == -3) {
            this.drainPlayerXPLevel(2);
            if (!player.level().isClientSide()) {
                this.setupResultSlot();
                this.broadcastChanges();
            }
            return true;
        }
        if (id == -4) {
            this.drainPlayerXPLevel(3);
            if (!player.level().isClientSide()) {
                this.setupResultSlot();
                this.broadcastChanges();
            }
            return true;
        }
        if (id == -5) {
            this.consumeItem();
            if (!player.level().isClientSide()) {
                this.setupResultSlot();
                this.broadcastChanges();
            }
            return true;
        }
        return false;
    }

    private void consumeItem() {
        if (this.consumeSlot.hasItem() && this.crystallineFlowerBlockEntity != null && !this.crystallineFlowerBlockEntity.isMaxTier()) {
            Player player;
            int tiersToMax = 7 - this.crystallineFlowerBlockEntity.getXpTier();
            int topBlock = CrystallineFlower.flowerHeightAbove((LevelReader)this.player.level(), this.crystallineFlowerBlockEntity.getBlockPos());
            List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(tiersToMax, this.player.level(), this.crystallineFlowerBlockEntity.getBlockPos().above(topBlock + 1));
            int xpPerCount = CrystallineFlower.getXpPerItem(this.consumeSlot.getItem());
            int itemCount = this.consumeSlot.getItem().getCount();
            long xpForStack = (long)itemCount * (long)xpPerCount;
            int xpToHighestAvailableTier = CrystallineFlower.getXpToHighestAvailableTier(this.crystallineFlowerBlockEntity, tiersToMax, obstructedAbove);
            int xpGranted = (int)Math.min((long)xpToHighestAvailableTier, xpForStack);
            int consumedItemCount = (int)Math.ceil((float)xpGranted / (float)xpPerCount);
            if (consumedItemCount == 0) {
                return;
            }
            this.crystallineFlowerBlockEntity.addXpAndTier(xpGranted);
            this.consumeSlot.remove(consumedItemCount);
            this.consumeSlotFullyObstructed();
            if (tiersToMax > 0 && this.crystallineFlowerBlockEntity.isMaxTier() && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((GenericTrigger)((Object)BzCriterias.GROW_CRYSTALLINE_FLOWER_TRIGGER.get())).trigger(serverPlayer);
            }
            this.syncXpTier();
            this.crystallineFlowerBlockEntity.syncPillar();
        }
    }

    public void consumeSlotFullyObstructed() {
        boolean fullyObstructed = false;
        if (this.consumeSlot.hasItem() && this.crystallineFlowerBlockEntity != null) {
            if (!this.crystallineFlowerBlockEntity.isMaxTier()) {
                int topBlock = CrystallineFlower.flowerHeightAbove((LevelReader)this.player.level(), this.crystallineFlowerBlockEntity.getBlockPos());
                List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(1, this.player.level(), this.crystallineFlowerBlockEntity.getBlockPos().above(topBlock + 1));
                if (!obstructedAbove.isEmpty() && obstructedAbove.get(0).booleanValue()) {
                    int xpPerCount = CrystallineFlower.getXpPerItem(this.consumeSlot.getItem());
                    int xpToMaxTier = this.crystallineFlowerBlockEntity.getXpForNextTiers(1) - 1;
                    int itemsConsumable = xpToMaxTier / xpPerCount;
                    fullyObstructed = itemsConsumable == 0;
                }
            } else {
                fullyObstructed = true;
            }
            if (fullyObstructed) {
                this.consumeSlotFullyObstructed.set(1);
            } else {
                this.consumeSlotFullyObstructed.set(0);
            }
            this.broadcastChanges();
            this.crystallineFlowerBlockEntity.setConsumeSlotItems(this.consumeSlot.getItem());
            this.crystallineFlowerBlockEntity.syncPillar();
        }
    }

    private void drainPlayerXPLevel(int desiredTierUpgrade) {
        if (this.crystallineFlowerBlockEntity != null && !this.crystallineFlowerBlockEntity.isMaxTier()) {
            Player player;
            int xpObtained;
            boolean isSpotObstructed;
            List<Boolean> obstructions = CrystallineFlower.getObstructions(desiredTierUpgrade, this.crystallineFlowerBlockEntity.getLevel(), this.crystallineFlowerBlockEntity.getBlockPos().above(this.crystallineFlowerBlockEntity.getXpTier()));
            int freeTierSpot = 0;
            Iterator<Boolean> iterator = obstructions.iterator();
            while (iterator.hasNext() && !(isSpotObstructed = iterator.next().booleanValue())) {
                ++freeTierSpot;
            }
            int xpRequested = this.crystallineFlowerBlockEntity.getXpForNextTiers(freeTierSpot);
            if (!this.player.getAbilities().instabuild) {
                xpObtained = (int)Math.min(EnchantmentUtils.getPlayerXP(this.player), (long)xpRequested);
                this.player.giveExperiencePoints(-xpRequested);
            } else {
                xpObtained = xpRequested;
            }
            this.crystallineFlowerBlockEntity.addXpAndTier(xpObtained);
            this.consumeSlotFullyObstructed();
            this.syncXpTier();
            if (desiredTierUpgrade > 0 && this.crystallineFlowerBlockEntity.isMaxTier() && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((GenericTrigger)((Object)BzCriterias.GROW_CRYSTALLINE_FLOWER_TRIGGER.get())).trigger(serverPlayer);
            }
        }
    }

    private void drainFlowerXPLevel(int levelToConsume) {
        if (this.crystallineFlowerBlockEntity != null && !this.crystallineFlowerBlockEntity.isMinTier()) {
            Player player;
            this.crystallineFlowerBlockEntity.decreaseTier(levelToConsume);
            this.consumeSlotFullyObstructed();
            this.syncXpTier();
            if (levelToConsume >= 5 && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((GenericTrigger)((Object)BzCriterias.ENCHANT_CRYSTALLINE_FLOWER_TRIGGER.get())).trigger(serverPlayer);
            }
        } else if (this.xpTier.get() > 1) {
            this.xpTier.set(Math.max(1, this.xpTier.get() - levelToConsume));
        }
    }

    protected void clearContainer(Player player, Container container) {
        this.enchantedSlot.container.removeItemNoUpdate(this.enchantedSlot.index);
    }

    public void removed(Player player) {
        super.removed(player);
        this.access.execute((level, blockPos) -> this.clearContainer(player, this.inputContainer));
    }

    public boolean stillValid(Player player) {
        return CrystallineFlowerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BzBlocks.CRYSTALLINE_FLOWER.get()));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemStack = itemstack1.copy();
            if (index == this.enchantedSlot.index) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemStack);
            } else if (index != this.consumeSlot.index && index != this.bookSlot.index) {
                if (!itemStack.is(BzTags.CAN_BE_ENCHANTED_ITEMS) && !this.moveItemStackTo(itemstack1, this.consumeSlot.index, this.consumeSlot.index + 1, false)) {
                    return ItemStack.EMPTY;
                }
                if (itemStack.is(BzTags.CAN_BE_ENCHANTED_ITEMS) && !this.moveItemStackTo(itemstack1, this.bookSlot.index, this.bookSlot.index + 1, false)) {
                    return ItemStack.EMPTY;
                }
                if (index >= 3 && index < 30 && !this.moveItemStackTo(itemstack1, 30, 39, false)) {
                    return ItemStack.EMPTY;
                }
                if (index >= 30 && index < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemStack;
    }

    private void setupResultSlot() {
        this.setupResultSlot(null);
    }

    private void setupResultSlot(ResourceLocation oldEnchantment) {
        ItemStack bookSlotItem = this.bookSlot.getItem();
        if (bookSlotItem.isEmpty() || this.xpTier.get() <= 1) {
            this.tooManyEnchantmentsOnInput.set(0);
            this.selectedEnchantment = null;
            if (this.enchantedSlot.hasItem()) {
                this.enchantedSlot.set(ItemStack.EMPTY);
            }
            return;
        }
        int existingEnchantments = ((ItemEnchantments)bookSlotItem.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).size();
        if (existingEnchantments >= 3) {
            this.tooManyEnchantmentsOnInput.set(1);
            this.selectedEnchantment = null;
            if (this.enchantedSlot.hasItem()) {
                this.enchantedSlot.set(ItemStack.EMPTY);
            }
            return;
        }
        this.tooManyEnchantmentsOnInput.set(0);
        ItemStack toEnchant = this.bookSlot.getItem();
        if (!toEnchant.isEmpty()) {
            Player tierCost2;
            ItemStack tempCopy = toEnchant.copy();
            tempCopy.setCount(1);
            Map<ResourceLocation, EnchantmentInstance> availableEnchantments = this.getAvailableEnchantments(this.crystallineFlowerBlockEntity.getLevel(), tempCopy);
            if (availableEnchantments.isEmpty()) {
                if (this.enchantedSlot.hasItem()) {
                    this.enchantedSlot.set(ItemStack.EMPTY);
                }
                this.selectedEnchantment = null;
            } else if (availableEnchantments.containsKey(oldEnchantment)) {
                this.selectedEnchantment = oldEnchantment;
            }
            if (this.selectedEnchantment != null && availableEnchantments.containsKey(this.selectedEnchantment)) {
                EnchantmentInstance enchantmentForItem = availableEnchantments.get(this.selectedEnchantment);
                if (tempCopy.is(Items.BOOK)) {
                    ItemStack enchantedBook = Items.ENCHANTED_BOOK.getDefaultInstance();
                    enchantedBook.setCount(1);
                    enchantedBook.applyComponents(tempCopy.getComponentsPatch());
                    tempCopy = enchantedBook;
                }
                if (tempCopy.is(Items.BOOK) || tempCopy.is(Items.ENCHANTED_BOOK)) {
                    tempCopy.enchant(enchantmentForItem.enchantment, enchantmentForItem.level);
                } else {
                    tempCopy.enchant(enchantmentForItem.enchantment, enchantmentForItem.level);
                }
                if (!ItemStack.matches((ItemStack)tempCopy, (ItemStack)this.enchantedSlot.getItem())) {
                    this.enchantedSlot.set(tempCopy);
                    int tierCost2 = EnchantmentUtils.getEnchantmentTierCost(enchantmentForItem);
                    this.tierCostUpper.set(GeneralUtils.split(tierCost2, true));
                    this.tierCostLower.set(GeneralUtils.split(tierCost2, false));
                }
            }
            if ((tierCost2 = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)tierCost2;
                List<EnchantmentSkeleton> availableEnchantmentsSkeletons = availableEnchantments.values().stream().map(e -> {
                    ResourceLocation resourceLocation = ((ResourceKey)e.enchantment.unwrapKey().get()).location();
                    return new EnchantmentSkeleton(resourceLocation.getPath(), resourceLocation.getNamespace(), e.level, ((Enchantment)e.enchantment.value()).getMinCost(resourceLocation.getNamespace().equals("minecraft") ? Math.max(e.level, 2) : e.level), e.level == ((Enchantment)e.enchantment.value()).getMaxLevel(), e.enchantment.is(EnchantmentTags.CURSE), e.enchantment.is(EnchantmentTags.TREASURE));
                }).toList();
                ResourceLocation selectedEnchant = this.selectedEnchantment == null ? ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty") : this.selectedEnchantment;
                CrystallineFlowerEnchantmentPacket.sendToClient(serverPlayer, this.containerId, availableEnchantmentsSkeletons, selectedEnchant);
            }
        }
    }

    private Map<ResourceLocation, EnchantmentInstance> getAvailableEnchantments(Level level, ItemStack tempCopy) {
        int enchantmentLevel = this.xpTier.get() * BzGeneralConfigs.crystallineFlowerEnchantingPowerAllowedPerTier;
        return EnchantmentUtils.allAllowedEnchantsWithoutMaxLimit(level, enchantmentLevel, tempCopy, this.xpTier.get());
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return super.canTakeItemForPickAll(stack, slot);
    }
}

