/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class CreatingHoneySlime {
    public static InteractionResult createHoneySlime(Level world, Player playerEntity, InteractionHand hand, Entity target) {
        ItemStack itemstack = playerEntity.getItemInHand(hand);
        if (target.getType().equals(EntityType.SLIME) && itemstack.is(BzTags.TURN_SLIME_TO_HONEY_SLIME)) {
            Slime slimeEntity = (Slime)target;
            int slimeSize = slimeEntity.getSize();
            if (slimeSize > 2) {
                return InteractionResult.PASS;
            }
            if (!world.isClientSide()) {
                HoneySlimeEntity honeySlimeMob = (HoneySlimeEntity)((EntityType)BzEntities.HONEY_SLIME.get()).create(world);
                honeySlimeMob.moveTo(target.getX(), target.getY(), target.getZ(), target.getYRot(), target.getXRot());
                honeySlimeMob.setBaby(slimeSize == 1);
                honeySlimeMob.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(BlockPos.containing((Position)honeySlimeMob.position())), MobSpawnType.TRIGGERED, null);
                world.addFreshEntity((Entity)honeySlimeMob);
                target.discard();
                world.playSound(playerEntity, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), honeySlimeMob.isBaby() ? (SoundEvent)BzSounds.HONEY_SLIME_SQUISH_SMALL.get() : (SoundEvent)BzSounds.HONEY_SLIME_SQUISH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            GeneralUtils.givePlayerItem(playerEntity, hand, ItemStack.EMPTY, true, true);
            playerEntity.swing(hand, true);
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                ((GenericTrigger)((Object)BzCriterias.HONEY_SLIME_CREATION_TRIGGER.get())).trigger(serverPlayer);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

