/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.SuperCandle;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.PotionCandleBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SuperCandleWick
extends Block
implements SimpleWaterloggedBlock,
BlockExtension {
    public static final BooleanProperty LIT = AbstractCandleBlock.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape AABB = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);
    private static final int NORMAL_LIGHT_LEVEL = 15;
    private static final int SOUL_LIGHT_LEVEL = 14;
    private final boolean isSoul;
    public static final MapCodec<SuperCandleWick> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("is_soul").forGetter(wick -> wick.isSoul), (App)SuperCandleWick.propertiesCodec()).apply((Applicative)instance, SuperCandleWick::new));

    public SuperCandleWick(boolean isSoul) {
        this(isSoul, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).lightLevel(blockState -> ((Boolean)blockState.getValue((Property)LIT)).booleanValue() ? (isSoul ? 14 : 15) : 0).replaceable().noCollission().noLootTable());
    }

    public SuperCandleWick(boolean isSoul, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.isSoul = isSoul;
    }

    public MapCodec<? extends SuperCandleWick> codec() {
        return CODEC;
    }

    public boolean isSoul() {
        return this.isSoul;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBlockState(blockPos.below()).getBlock() instanceof SuperCandle;
    }

    public void neighborChanged(BlockState blockstate, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (!this.canSurvive(blockstate, (LevelReader)level, pos)) {
            FluidState fluidState = level.getFluidState(pos);
            level.levelEvent(2001, pos, Block.getId((BlockState)blockstate));
            boolean bl2 = level.setBlock(pos, fluidState.createLegacyBlock(), 3, 512);
            if (bl2) {
                level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(null, (BlockState)blockstate));
            }
        } else {
            super.neighborChanged(blockstate, level, pos, block, fromPos, notify);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(BzTags.CANDLE_WICKS) || !newState.is(BzTags.CANDLE_WICKS)) {
            SuperCandleWick.setBelowLit((LevelAccessor)level, pos, false);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter world, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) == false && fluid.is(FluidTags.WATER) && fluid.defaultFluidState().isSource();
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && fluidState.is(FluidTags.WATER) && fluidState.isSource()) {
            BlockState blockstate = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
            if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                SuperCandleWick.extinguish(null, blockstate, level, pos);
            } else {
                level.setBlock(pos, blockstate, 3);
            }
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            return true;
        }
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue() && entity instanceof Projectile) {
            Entity entity2;
            boolean litWick;
            Projectile projectile = (Projectile)entity;
            if (!level.isClientSide && projectile.isOnFire() && SuperCandle.canBeLit(level, state, pos.below()) && (litWick = SuperCandleWick.setLit((LevelAccessor)level, level.getBlockState(pos), pos, true)) && (entity2 = projectile.getOwner()) instanceof ServerPlayer) {
                PotionCandleBlockEntity potionCandleBlockEntity;
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                BlockEntity blockEntity = level.getBlockEntity(pos.below());
                if (blockEntity instanceof PotionCandleBlockEntity && (potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity).getMobEffect() != null && ((MobEffect)potionCandleBlockEntity.getMobEffect().value()).isInstantenous() && !((MobEffect)potionCandleBlockEntity.getMobEffect().value()).isBeneficial()) {
                    ((GenericTrigger)((Object)BzCriterias.PROJECTILE_LIGHT_INSTANT_POTION_CANDLE_TRIGGER.get())).trigger(serverPlayer);
                }
            }
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !level.isClientSide()) {
            boolean entityInSpace;
            boolean isProjectile = entity instanceof Projectile;
            boolean bl = entityInSpace = isProjectile || Shapes.joinIsNotEmpty((VoxelShape)AABB.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (VoxelShape)Shapes.create((AABB)entity.getBoundingBox()), (BooleanOp)BooleanOp.AND);
            if (entityInSpace && (BzGeneralConfigs.superCandlesBurnsMobs || isProjectile) && !entity.fireImmune()) {
                entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 1);
                if (entity.getRemainingFireTicks() <= 0) {
                    entity.setRemainingFireTicks(1);
                }
                entity.hurt(level.damageSources().inFire(), 0.5f);
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    public static boolean isSoulBelowInRange(LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.set((Vec3i)blockPos);
        ChunkAccess chunkAccess = levelAccessor.getChunk(blockPos);
        for (int i = 0; i < mutableBlockPos.getY() - chunkAccess.getMinBuildHeight(); ++i) {
            BlockState currentState = chunkAccess.getBlockState((BlockPos)mutableBlockPos);
            if (currentState.is(BlockTags.SOUL_FIRE_BASE_BLOCKS)) {
                return true;
            }
            if (!currentState.is(BzTags.CANDLE_BASES)) {
                return false;
            }
            mutableBlockPos.move(Direction.DOWN);
        }
        return false;
    }

    public static BlockPos getLitWickPositionAbove(LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.set((Vec3i)blockPos);
        ChunkAccess chunkAccess = levelAccessor.getChunk(blockPos);
        for (int i = 0; i < chunkAccess.getMaxBuildHeight() - mutableBlockPos.getY(); ++i) {
            BlockState currentState = chunkAccess.getBlockState((BlockPos)mutableBlockPos);
            if (currentState.is(BzTags.CANDLE_WICKS)) {
                return mutableBlockPos.immutable();
            }
            if (!currentState.is(BzTags.CANDLE_BASES)) {
                return null;
            }
            mutableBlockPos.move(Direction.UP);
        }
        return null;
    }

    public static boolean setLit(LevelAccessor levelAccessor, BlockState blockState, BlockPos blockPos, boolean lit) {
        if (!(!(blockState.getBlock() instanceof SuperCandleWick) || lit && ((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue())) {
            boolean litWick;
            boolean isBelowSoul = SuperCandleWick.isSoulBelowInRange(levelAccessor, blockPos.below());
            Block wickBlock = isBelowSoul && lit ? (Block)BzBlocks.SUPER_CANDLE_WICK_SOUL.get() : (Block)BzBlocks.SUPER_CANDLE_WICK.get();
            boolean bl = litWick = levelAccessor.setBlock(blockPos, (BlockState)((BlockState)wickBlock.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(lit))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)blockState.getValue((Property)WATERLOGGED))), 11) && lit;
            if (lit) {
                levelAccessor.playSound(null, blockPos, (SoundEvent)BzSounds.SUPER_CANDLE_WICK_LIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            SuperCandleWick.setBelowLit(levelAccessor, blockPos, lit);
            return litWick;
        }
        return false;
    }

    public static void setBelowLit(LevelAccessor levelAccessor, BlockPos blockPos, boolean lit) {
        BlockPos belowPos = blockPos.below();
        BlockState candleBase = levelAccessor.getBlockState(belowPos);
        if (candleBase.getBlock() instanceof SuperCandle) {
            levelAccessor.setBlock(belowPos, (BlockState)candleBase.setValue((Property)LIT, (Comparable)Boolean.valueOf(lit)), 11);
        }
    }

    public static void extinguish(Player player, BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
        SuperCandleWick.setLit(levelAccessor, blockState, blockPos, false);
        if (blockState.getBlock() instanceof SuperCandleWick) {
            levelAccessor.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.2, (double)blockPos.getZ() + 0.5, 0.0, (double)0.1f, 0.0);
        }
        levelAccessor.playSound(null, blockPos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        levelAccessor.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            SuperCandleWick.addParticlesAndSound(level, new Vec3((double)pos.getX() + 0.5 + (random.nextDouble() * 0.26 - 0.13), (double)pos.getY() + 0.75 + random.nextDouble() * 0.15, (double)pos.getZ() + 0.5 + (random.nextDouble() * 0.26 - 0.13)), random, this.isSoul);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.55, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        if (blockState.is(BzTags.CANDLE_WICKS) && ((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            if (this.isSoul) {
                return 3;
            }
            return 5;
        }
        return 0;
    }

    private static void addParticlesAndSound(Level level, Vec3 offset, RandomSource random, boolean isSoul) {
        float chance = random.nextFloat();
        if (chance < 0.5f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
            if (chance < 0.17f) {
                level.playLocalSound(offset.x, offset.y + 0.5, offset.z, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        if (chance < 0.2f) {
            if (isSoul) {
                level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, offset.x, offset.y - 0.75, offset.z, 0.0, 0.0, 0.0);
            } else {
                level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, offset.x, offset.y - 0.75, offset.z, 0.0, 0.0, 0.0);
            }
        }
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return !blockState.hasProperty((Property)LIT) || (Boolean)blockState.getValue((Property)LIT) == false;
    }

    @Override
    public PathType bz$getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, Mob mob) {
        if (state.hasProperty((Property)LIT) && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return PathType.DAMAGE_FIRE;
        }
        return null;
    }

    public static void attemptCandleLighting(LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockState currentState = levelAccessor.getBlockState(blockPos);
        if (currentState.is(BzTags.CANDLE_BASES)) {
            currentState = levelAccessor.getBlockState(blockPos.above());
        }
        if (currentState.getBlock() instanceof SuperCandleWick && !((Boolean)currentState.getValue((Property)LIT)).booleanValue() && !((Boolean)currentState.getValue((Property)WATERLOGGED)).booleanValue()) {
            boolean isBelowSoul = SuperCandleWick.isSoulBelowInRange(levelAccessor, blockPos.below());
            Block wickBlock = isBelowSoul ? (Block)BzBlocks.SUPER_CANDLE_WICK_SOUL.get() : (Block)BzBlocks.SUPER_CANDLE_WICK.get();
            levelAccessor.setBlock(blockPos, (BlockState)wickBlock.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 11);
            levelAccessor.playSound(null, blockPos, (SoundEvent)BzSounds.SUPER_CANDLE_WICK_LIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            SuperCandleWick.setBelowLit(levelAccessor, blockPos, true);
        }
    }
}

