/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.SuperCandle;
import com.telepathicgrunt.the_bumblezone.blocks.SuperCandleWick;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.PotionCandleBlockEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PotionCandleBase
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
SuperCandle,
BlockExtension {
    public static final BooleanProperty LIT = AbstractCandleBlock.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape AABB = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final MapCodec<PotionCandleBase> CODEC = Block.simpleCodec(PotionCandleBase::new);

    public PotionCandleBase() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).lightLevel(blockState -> (Boolean)blockState.getValue((Property)LIT) != false ? 15 : 0).noOcclusion().strength(0.1f).sound(SoundType.CANDLE).pushReaction(PushReaction.DESTROY));
    }

    public PotionCandleBase(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public MapCodec<? extends PotionCandleBase> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, WATERLOGGED});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        SuperCandle.placeWickIfPossible((LevelAccessor)level, pos, false);
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.is(FluidTags.WATER) && fluidstate.isSource();
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        SuperCandle.placeWickIfPossible((LevelAccessor)world, pos, false);
        super.neighborChanged(blockstate, world, pos, block, fromPos, notify);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter world, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) == false && fluid.is(FluidTags.WATER) && fluid.defaultFluidState().isSource();
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && fluidState.is(FluidTags.WATER) && fluidState.isSource()) {
            BlockState blockstate = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
            level.setBlock(pos, blockstate, 3);
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            return true;
        }
        return false;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide() && oldState.is((Block)BzBlocks.POTION_BASE_CANDLE.get()) && state.is((Block)BzBlocks.POTION_BASE_CANDLE.get())) {
            if (((Boolean)oldState.getValue((Property)LIT)).booleanValue() && !((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof PotionCandleBlockEntity) {
                    PotionCandleBlockEntity potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity;
                    potionCandleBlockEntity.resetCurrentDuration();
                    potionCandleBlockEntity.resetInstantStartTime();
                }
            } else if (!((Boolean)oldState.getValue((Property)LIT)).booleanValue() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                this.resetTimingFields(level, pos);
            }
        }
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!(!player.mayInteract(level, blockPos) || PlatformHooks.isNeoForge() && PlatformHooks.isItemAbility(itemStack, null, "firestarter_light") || !this.CandleUnlightBehaviors(itemStack, blockState, level, blockPos, player, false) && !this.CandleLightBehaviors(itemStack, blockState, level, blockPos, player, interactionHand, false))) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        Entity entity;
        boolean litWick;
        if (projectile.isOnFire() && SuperCandle.canBeLit(level, state, hit.getBlockPos()) && (litWick = SuperCandleWick.setLit((LevelAccessor)level, level.getBlockState(hit.getBlockPos().above()), hit.getBlockPos().above(), true)) && (entity = projectile.getOwner()) instanceof ServerPlayer) {
            PotionCandleBlockEntity potionCandleBlockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            BlockEntity blockEntity = level.getBlockEntity(hit.getBlockPos());
            if (blockEntity instanceof PotionCandleBlockEntity && (potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity).getMobEffect() != null && ((MobEffect)potionCandleBlockEntity.getMobEffect().value()).isInstantenous() && !((MobEffect)potionCandleBlockEntity.getMobEffect().value()).isBeneficial()) {
                ((GenericTrigger)((Object)BzCriterias.PROJECTILE_LIGHT_INSTANT_POTION_CANDLE_TRIGGER.get())).trigger(serverPlayer);
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (player != null && player.getAbilities().instabuild) {
            return super.playerWillDestroy(level, pos, state, player);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PotionCandleBlockEntity) {
            PotionCandleBlockEntity potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity;
            ItemStack itemStack = ((Item)BzItems.POTION_CANDLE.get()).getDefaultInstance();
            potionCandleBlockEntity.saveToItem(itemStack, (HolderLookup.Provider)level.registryAccess());
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BzBlockEntities.POTION_CANDLE.get()).create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PotionCandleBase.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)BzBlockEntities.POTION_CANDLE.get()), (BlockEntityTicker)(level.isClientSide ? (a, b, c, d) -> {} : PotionCandleBlockEntity::serverTick));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return blockState.is(BzTags.CANDLES) && (Boolean)blockState.getValue((Property)LIT) != false ? 5 : 0;
    }

    private void resetTimingFields(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof PotionCandleBlockEntity) {
            PotionCandleBlockEntity potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity;
            potionCandleBlockEntity.resetCurrentDuration();
            potionCandleBlockEntity.setInstantStartTime(Math.max(level.getGameTime() - 1L, 0L));
        }
    }

    public static int getItemColor(ItemStack itemStack) {
        CompoundTag tag;
        CustomData customData = (CustomData)itemStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null && !customData.isEmpty() && (tag = customData.copyTag()).contains("color")) {
            return tag.getInt("color");
        }
        return 0xFFFFFF;
    }

    public static int getBlockColor(BlockAndTintGetter world, BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (world != null && (blockEntity = world.getBlockEntity(pos)) instanceof PotionCandleBlockEntity) {
            PotionCandleBlockEntity potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity;
            int currentColor = potionCandleBlockEntity.getColor();
            if (tintIndex == 1) {
                int red = Math.max(currentColor >> 16 & 0xFF, 40);
                int green = Math.max(currentColor >> 8 & 0xFF, 10);
                int blue = Math.max(currentColor & 0xFF, 5);
                currentColor = (Math.min(red + 60, 255) << 16) + (Math.min(green + 30, 255) << 8) + Math.min(blue + 25, 255);
            }
            return currentColor;
        }
        return tintIndex;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos position, RandomSource random) {
        PotionCandleBlockEntity potionCandleBlockEntity;
        BlockEntity blockEntity;
        if (blockState.hasProperty((Property)LIT) && ((Boolean)blockState.getValue((Property)LIT)).booleanValue() && (blockEntity = level.getBlockEntity(position)) instanceof PotionCandleBlockEntity && (potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity).getMobEffect() != null) {
            int color = potionCandleBlockEntity.getColor();
            Vec3 colorRGB = PotionCandleBlockEntity.convertIntegerColorToRGB(color);
            for (int i = 0; i < random.nextInt(3); ++i) {
                this.spawnEffectParticles(level, random, position, (float)colorRGB.x(), (float)colorRGB.y(), (float)colorRGB.z());
            }
        }
        super.animateTick(blockState, level, position, random);
    }

    private void spawnEffectParticles(Level level, RandomSource random, BlockPos position, float red, float green, float blue) {
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)red, (float)green, (float)blue), (double)position.getX() + 0.4 + random.nextDouble() * 0.2, (double)position.getY() + 0.7 + random.nextDouble() * 0.2, (double)position.getZ() + 0.4 + random.nextDouble() * 0.2, 0.0, 0.0, 0.0);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return !blockState.hasProperty((Property)LIT) || (Boolean)blockState.getValue((Property)LIT) == false;
    }

    @Override
    public PathType bz$getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, Mob mob) {
        if (state.hasProperty((Property)LIT) && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return PathType.DAMAGE_FIRE;
        }
        return null;
    }
}

