/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public record InvalidateEntityCache(int entityId) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final StructEndec<InvalidateEntityCache> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", InvalidateEntityCache::entityId), InvalidateEntityCache::new);

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(InvalidateEntityCache packet, Player player) {
        Level level = player.level();
        Entity entity = level.getEntity(packet.entityId());
        if (entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        AccessoriesHolderLookupCache cache = ((AccessoriesHolderImpl)capability.getHolder()).getLookupCache();
        if (cache != null) {
            cache.clearCache();
        }
    }
}

