/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.client.gui.AccessoriesExperimentalScreen;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.menu.AccessoriesMenuData;
import io.wispforest.accessories.menu.variants.AccessoriesExperimentalMenu;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.function.TriFunction;

public class AccessoriesMenuTypes {
    public static MenuType<AccessoriesMenu> ORIGINAL_MENU;
    public static MenuType<AccessoriesExperimentalMenu> EXPERIMENTAL_MENU;

    public static void registerMenuType() {
        ORIGINAL_MENU = AccessoriesMenuTypes.registerMenuType("original_menu", AccessoriesMenu::of);
        EXPERIMENTAL_MENU = AccessoriesMenuTypes.registerMenuType("experimental_menu", AccessoriesExperimentalMenu::of);
    }

    private static <T extends AbstractContainerMenu> MenuType<T> registerMenuType(String path, TriFunction<Integer, Inventory, AccessoriesMenuData, T> func) {
        return AccessoriesInternals.registerMenuType(Accessories.of(path), AccessoriesMenuData.ENDEC, func);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <M extends AbstractContainerMenu, U extends Screen> void registerClientMenuConstructors(MenuRegisterCallback callback) {
        callback.register(ORIGINAL_MENU, AccessoriesScreen::new);
        callback.register(EXPERIMENTAL_MENU, AccessoriesExperimentalScreen::new);
    }

    public static interface MenuRegisterCallback {
        public <M extends AbstractContainerMenu, U extends Screen> void register(MenuType<? extends M> var1, MenuScreens.ScreenConstructor<M, U> var2);
    }
}

