/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.compat.config.SlotAmountModifier;
import io.wispforest.accessories.data.OperationType;
import io.wispforest.accessories.data.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.impl.SlotTypeImpl;
import io.wispforest.accessories.utils.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SlotTypeLoader
extends ReplaceableJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    public static final SlotTypeLoader INSTANCE = new SlotTypeLoader();
    private SequencedMap<String, SlotType> server = new LinkedHashMap<String, SlotType>();
    private SequencedMap<String, SlotType> client = new LinkedHashMap<String, SlotType>();
    private final Map<EntityType<?>, Collection<SlotType>> slotUsedByRegistryItemCache_server = new HashMap();
    private final Map<EntityType<?>, Collection<SlotType>> slotUsedByRegistryItemCache_client = new HashMap();

    protected SlotTypeLoader() {
        super(GSON, LOGGER, "accessories/slot");
    }

    @Nullable
    public static SlotType getSlotType(LivingEntity entity, String slotName) {
        return SlotTypeLoader.getSlotTypes(entity.level()).get(slotName);
    }

    @Nullable
    public static SlotType getSlotType(Level level, String slotName) {
        return SlotTypeLoader.getSlotTypes(level).get(slotName);
    }

    public static Map<String, SlotType> getSlotTypes(Level level) {
        return INSTANCE.getSlotTypes(level.isClientSide());
    }

    public final Map<String, SlotType> getSlotTypes(boolean isClientSide) {
        return isClientSide ? this.client : this.server;
    }

    private static Map<EntityType<?>, Collection<SlotType>> getUsedSlots(boolean isClientSide) {
        return isClientSide ? SlotTypeLoader.INSTANCE.slotUsedByRegistryItemCache_client : SlotTypeLoader.INSTANCE.slotUsedByRegistryItemCache_server;
    }

    public static Collection<SlotType> getUsedSlotsByRegistryItem(LivingEntity living) {
        Map<EntityType<?>, Collection<SlotType>> map = SlotTypeLoader.getUsedSlots(living.level().isClientSide());
        if (map.containsKey(living.getType())) {
            return map.get(living.getType());
        }
        LinkedHashSet<SlotType> validSlotTypes = new LinkedHashSet<SlotType>();
        BuiltInRegistries.ITEM.forEach(item -> {
            ItemStack stack = item.getDefaultInstance();
            Collection<SlotType> validSlots = AccessoriesAPI.getStackSlotTypes(living, stack);
            validSlotTypes.addAll(validSlots);
        });
        map.put(living.getType(), validSlotTypes);
        return validSlotTypes;
    }

    @ApiStatus.Internal
    public void setSlotType(SequencedMap<String, SlotType> slotTypes) {
        this.client = Collections.unmodifiableSequencedMap(slotTypes);
        this.slotUsedByRegistryItemCache_client.clear();
    }

    protected void apply(Map<ResourceLocation, JsonObject> data, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<String, SlotBuilder> uniqueSlots = new HashMap<String, SlotBuilder>();
        try {
            UniqueSlotHandling.gatherUniqueSlots((TriFunction<ResourceLocation, Integer, Collection<ResourceLocation>, SlotTypeReference>)((TriFunction)(location, integer, slotPredicates) -> {
                String name = location.toString();
                if (uniqueSlots.containsKey(name)) {
                    throw new IllegalStateException("Unable to register the given unique slot as a existing slot has been registered before! [Name: " + name + "]");
                }
                SlotBuilder builder = new SlotBuilder(name);
                builder.amount((int)integer);
                uniqueSlots.put(name, builder);
                slotPredicates.forEach(builder::validator);
                return new SlotTypeReference(name);
            }));
        }
        catch (Exception e) {
            LOGGER.error("[SlotTypeLoader]: Error occurred when trying to gather unique slots though code!", (Throwable)e);
        }
        HashMap<String, SlotBuilder> builders = new HashMap<String, SlotBuilder>();
        builders.putAll(uniqueSlots);
        for (Map.Entry<ResourceLocation, JsonObject> resourceEntry : data.entrySet()) {
            Integer amount;
            ResourceLocation location2 = resourceEntry.getKey();
            JsonObject jsonObject = resourceEntry.getValue();
            if (!AccessoriesInternals.isValidOnConditions(jsonObject, this.directory, location2, null)) continue;
            String[] pathParts = location2.getPath().split("/");
            String slotName = pathParts[pathParts.length - 1];
            String namespace = pathParts.length > 1 ? pathParts[0] + ":" : "";
            SlotBuilder slotBuilder2 = builders.computeIfAbsent(namespace + slotName, SlotBuilder::new);
            slotBuilder2.icon(this.safeHelper((object, s) -> ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)object, (String)s)), jsonObject, "icon", location2));
            slotBuilder2.order(this.safeHelper(GsonHelper::getAsInt, jsonObject, "order", location2));
            if (ExtraSlotTypeProperties.getProperty(slotBuilder2.name, false).allowResizing() && (amount = this.safeHelper(GsonHelper::getAsInt, jsonObject, "amount", location2)) != null) {
                OperationType operation = this.safeHelper((jsonObject1, s) -> {
                    try {
                        return OperationType.valueOf(GsonHelper.getAsString((JsonObject)jsonObject1, (String)s).toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }, jsonObject, "operation", null, location2);
                if (operation != null) {
                    switch (operation) {
                        case SET: {
                            slotBuilder2.amount(amount);
                            break;
                        }
                        case ADD: {
                            slotBuilder2.addAmount(amount);
                            break;
                        }
                        case SUB: {
                            slotBuilder2.subtractAmount(amount);
                        }
                    }
                } else {
                    LOGGER.error("Unable to understand the passed operation for the given slot type file! [Location: {}, Operation: {}]", (Object)location2, (Object)operation);
                }
            }
            if (!ExtraSlotTypeProperties.getProperty(slotBuilder2.name, false).strictMode()) {
                JsonArray validators = this.safeHelper(GsonHelper::getAsJsonArray, jsonObject, "validators", new JsonArray(), location2);
                this.decodeJsonArray(validators, "validator", location2, element -> ResourceLocation.tryParse((String)element.getAsString()), slotBuilder2::validator);
            }
            slotBuilder2.dropRule(this.safeHelper((object, s) -> DropRule.valueOf(GsonHelper.getAsString((JsonObject)object, (String)s).toUpperCase(Locale.ROOT)), jsonObject, "drop_rule", location2));
            builders.put(slotBuilder2.name, slotBuilder2);
        }
        HashMap tempMap = new HashMap();
        for (SlotAmountModifier modifier : Accessories.config().modifiers()) {
            SlotBuilder builder = builders.getOrDefault(modifier.slotType, null);
            if (builder == null) continue;
            builder.addAmount(modifier.amount);
        }
        uniqueSlots.forEach((s, slotBuilder) -> tempMap.put(s, slotBuilder.create()));
        builders.forEach((s, slotBuilder) -> {
            if (s.equals("any")) {
                return;
            }
            tempMap.put(s, slotBuilder.create());
        });
        this.server = Collections.unmodifiableSequencedMap(tempMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(CollectionUtils.toLinkedMap()));
        this.slotUsedByRegistryItemCache_server.clear();
    }

    public static class SlotBuilder {
        private final String name;
        private ResourceLocation icon = null;
        private Integer order = null;
        public Integer baseAmount = null;
        private Integer offsetAmount = 0;
        private final Set<ResourceLocation> validators = new HashSet<ResourceLocation>();
        private DropRule dropRule = null;
        private Optional<String> alternativeTranslation = Optional.empty();

        public SlotBuilder(String name) {
            this.name = name;
        }

        public SlotBuilder alternativeTranslation(String value) {
            this.alternativeTranslation = Optional.of(value);
            return this;
        }

        public SlotBuilder icon(ResourceLocation value) {
            if (value != null) {
                this.icon = value;
            }
            return this;
        }

        public SlotBuilder order(Integer value) {
            if (value != null) {
                this.order = value;
            }
            return this;
        }

        public SlotBuilder amount(int value) {
            this.baseAmount = value;
            return this;
        }

        public SlotBuilder addAmount(int value) {
            this.offsetAmount = this.offsetAmount + value;
            return this;
        }

        public SlotBuilder subtractAmount(int value) {
            this.offsetAmount = this.offsetAmount - value;
            return this;
        }

        public SlotBuilder validator(ResourceLocation validator) {
            this.validators.add(validator);
            return this;
        }

        public SlotBuilder dropRule(DropRule value) {
            if (value != null) {
                this.dropRule = value;
            }
            return this;
        }

        public SlotType create() {
            if (this.validators.isEmpty()) {
                this.validators.add(Accessories.of("tag"));
                this.validators.add(Accessories.of("component"));
            }
            Integer defaultedBaseAmount = Optional.ofNullable(this.baseAmount).map(i -> Math.max(i, 0)).orElse(1);
            defaultedBaseAmount = this.offsetAmount + defaultedBaseAmount;
            return new SlotTypeImpl(this.name, this.alternativeTranslation, Optional.ofNullable(this.icon).orElse(SlotType.EMPTY_SLOT_ICON), Optional.ofNullable(this.order).orElse(1000), defaultedBaseAmount, this.validators, Optional.ofNullable(this.dropRule).orElse(DropRule.DEFAULT));
        }
    }
}

