/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesContainer {
    public AccessoriesCapability capability();

    public String getSlotName();

    @Nullable
    default public SlotType slotType() {
        return SlotTypeLoader.getSlotType(this.capability().entity(), this.getSlotName());
    }

    default public SlotReference createReference(int index) {
        return SlotReference.of(this.capability().entity(), this.getSlotName(), index);
    }

    public List<Boolean> renderOptions();

    default public boolean shouldRender(int index) {
        List<Boolean> options = this.renderOptions();
        return index < options.size() ? options.get(index) : true;
    }

    public ExpandedSimpleContainer getAccessories();

    public ExpandedSimpleContainer getCosmeticAccessories();

    public int getSize();

    public void markChanged(boolean var1);

    default public void markChanged() {
        this.markChanged(true);
    }

    public boolean hasChanged();

    public void update();

    public Map<ResourceLocation, AttributeModifier> getModifiers();

    public Set<AttributeModifier> getCachedModifiers();

    public Collection<AttributeModifier> getModifiersForOperation(AttributeModifier.Operation var1);

    public void addTransientModifier(AttributeModifier var1);

    public void addPersistentModifier(AttributeModifier var1);

    public boolean hasModifier(ResourceLocation var1);

    public void removeModifier(ResourceLocation var1);

    public void clearModifiers();

    public void removeCachedModifiers(AttributeModifier var1);

    public void clearCachedModifiers();
}

