/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc.client.screen;

import dev.wuffs.bcc.BetterCompatibilityChecker;
import dev.wuffs.bcc.data.BetterStatus;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CompatabilityRender {
    private static final ResourceLocation ICON_SHEET = ResourceLocation.fromNamespaceAndPath((String)"bcc", (String)"textures/gui/icons.png");

    public static void render(JoinMultiplayerScreen gui, BetterStatus serverStatus, GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY) {
        if (serverStatus == null) {
            return;
        }
        BetterStatus localStatus = BetterCompatibilityChecker.getBetterStatus();
        if (localStatus == null) {
            return;
        }
        int idx = 0;
        String langKey = "bcc.gui.tooltip.compatible_server";
        if (!BetterCompatibilityChecker.comparePingData(serverStatus)) {
            idx = 16;
            langKey = "bcc.gui.tooltip.incompatible_server";
        }
        Object tooltip = Component.translatable((String)langKey, (Object[])new Object[]{serverStatus.name() + " " + serverStatus.version(), localStatus.name() + " " + localStatus.version()}).getString();
        tooltip = (String)tooltip + "\n \n" + String.valueOf(ChatFormatting.DARK_GRAY) + "Better Compatibility Checker";
        guiGraphics.blit(ICON_SHEET, x + width - 18, y + 10, 16, 16, 0.0f, (float)idx, 16, 16, 16, 32);
        if (mouseX > width - 15 && mouseX < width && mouseY > 10 && mouseY < 26) {
            gui.setTooltipForNextRenderPass(Minecraft.getInstance().font.split((FormattedText)Component.literal((String)tooltip), 370));
        }
    }
}

