/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.client.gui.Page;
import com.cazsius.solcarrot.client.gui.elements.UIItemStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

final class ItemListPage
extends Page {
    private static final int itemsPerRow = 5;
    private static final int rowsPerPage = 6;
    private static final int itemsPerPage = 30;
    private static final int itemSpacing = 20;

    static List<ItemListPage> pages(Rectangle frame, String header, List<ItemStack> items) {
        ArrayList<ItemListPage> pages = new ArrayList<ItemListPage>();
        for (int startIndex = 0; startIndex < items.size(); startIndex += 30) {
            int endIndex = Math.min(startIndex + 30, items.size());
            pages.add(new ItemListPage(frame, header, items.subList(startIndex, endIndex)));
        }
        return pages;
    }

    private ItemListPage(Rectangle frame, String header, List<ItemStack> items) {
        super(frame, header);
        int minX = -40;
        int minY = -54;
        for (int i = 0; i < items.size(); ++i) {
            ItemStack itemStack = items.get(i);
            int x = minX + 20 * (i % 5);
            int y = minY + 20 * (i / 5 % 6);
            UIItemStack view = new UIItemStack(itemStack);
            view.setCenterX(this.getCenterX() + x);
            view.setCenterY(this.getCenterY() + y);
            this.children.add(view);
        }
    }
}

