/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.CraftingCoreContainer;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.tileentity.PedestalTileEntity;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CraftingCoreTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private final BaseItemStackHandler inventory = CraftingCoreTileEntity.createInventoryHandler(slot -> this.setChanged());
    private final BaseItemStackHandler recipeInventory;
    private final BaseEnergyStorage energy = new BaseEnergyStorage(((Integer)ModConfigs.CRAFTING_CORE_POWER_CAPACITY.get()).intValue(), () -> ((CraftingCoreTileEntity)this).setChangedFast());
    private final CachedRecipe<CraftingInput, ICombinationRecipe> recipe;
    private int progress;
    private int pedestalCount;
    private boolean haveItemsChanged = true;

    public CraftingCoreTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.CRAFTING_CORE.get(), pos, state);
        this.recipeInventory = BaseItemStackHandler.create((int)49);
        this.recipe = new CachedRecipe((RecipeType)ModRecipeTypes.COMBINATION.get());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("Energy", this.energy.getEnergyStored());
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.extendedcrafting.crafting_core").build();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return CraftingCoreContainer.create(windowId, playerInventory, this.getBlockPos());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CraftingCoreTileEntity tile) {
        ICombinationRecipe recipe = tile.getActiveRecipe();
        if (recipe != null) {
            if (tile.energy.getEnergyStored() > 0) {
                boolean done = tile.process(recipe);
                Map<BlockPos, ItemStack> pedestalsWithItems = tile.getPedestalsWithItems();
                if (done) {
                    CraftingInput input = tile.toCraftingInput();
                    NonNullList remaining = recipe.getRemainingItems((RecipeInput)input);
                    int index = 1;
                    for (BlockPos pedestalPos : pedestalsWithItems.keySet()) {
                        BlockEntity pedestalTile = level.getBlockEntity(pedestalPos);
                        if (pedestalTile instanceof PedestalTileEntity) {
                            PedestalTileEntity pedestal = (PedestalTileEntity)pedestalTile;
                            BaseItemStackHandler inventory = pedestal.getInventory();
                            inventory.setStackInSlot(0, (ItemStack)remaining.get(index));
                            tile.spawnParticles(ParticleTypes.SMOKE, pedestalPos, 1.1, 20);
                        }
                        ++index;
                    }
                    tile.spawnParticles(ParticleTypes.END_ROD, pos, 1.1, 50);
                    tile.inventory.setStackInSlot(0, recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess()));
                    tile.progress = 0;
                    tile.setChangedFast();
                } else {
                    tile.spawnParticles(ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)Utils.randInt((int)0, (int)255), (int)Utils.randInt((int)0, (int)255), (int)Utils.randInt((int)0, (int)255))), pos, 1.15, 2);
                    if (tile.shouldSpawnItemParticles()) {
                        for (BlockPos pedestalPos : pedestalsWithItems.keySet()) {
                            BlockEntity pedestalTile = level.getBlockEntity(pedestalPos);
                            if (!(pedestalTile instanceof PedestalTileEntity)) continue;
                            PedestalTileEntity pedestal = (PedestalTileEntity)pedestalTile;
                            BaseItemStackHandler inventory = pedestal.getInventory();
                            ItemStack stack = inventory.getStackInSlot(0);
                            tile.spawnItemParticles(pedestalPos, stack);
                        }
                    }
                }
            }
        } else if (tile.progress > 0) {
            tile.progress = 0;
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)1, (OnContentsChangedFunction)onContentsChanged, builder -> builder.setDefaultSlotLimit(1));
    }

    public BaseEnergyStorage getEnergy() {
        return this.energy;
    }

    public ICombinationRecipe getActiveRecipe() {
        if (this.level == null) {
            return null;
        }
        Map<BlockPos, ItemStack> pedestalsWithItems = this.getPedestalsWithItems();
        ItemStack[] stacks = pedestalsWithItems.values().toArray(new ItemStack[0]);
        this.updateRecipeInventory(stacks);
        if (!this.haveItemsChanged) {
            return (ICombinationRecipe)this.recipe.get();
        }
        return (ICombinationRecipe)this.recipe.checkAndGet((RecipeInput)this.toCraftingInput(), this.level);
    }

    public boolean hasRecipe() {
        return this.recipe.exists();
    }

    public int getEnergyRequired() {
        return this.hasRecipe() ? ((ICombinationRecipe)this.recipe.get()).getPowerCost() : 0;
    }

    public int getEnergyRate() {
        return this.hasRecipe() ? ((ICombinationRecipe)this.recipe.get()).getPowerRate() : 0;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getPedestalCount() {
        return this.pedestalCount;
    }

    private void updateRecipeInventory(ItemStack[] items) {
        int i;
        boolean haveItemsChanged;
        boolean bl = haveItemsChanged = this.recipeInventory.getSlots() != items.length + 1 || !StackHelper.areStacksEqual((ItemStack)this.recipeInventory.getStackInSlot(0), (ItemStack)this.inventory.getStackInSlot(0));
        if (!haveItemsChanged) {
            for (i = 0; i < items.length; ++i) {
                if (StackHelper.areStacksEqual((ItemStack)this.recipeInventory.getStackInSlot(i + 1), (ItemStack)items[i])) continue;
                haveItemsChanged = true;
                break;
            }
        }
        this.haveItemsChanged = haveItemsChanged;
        if (!haveItemsChanged) {
            return;
        }
        this.recipeInventory.setSize(items.length + 1);
        this.recipeInventory.setStackInSlot(0, this.inventory.getStackInSlot(0));
        for (i = 0; i < items.length; ++i) {
            this.recipeInventory.setStackInSlot(i + 1, items[i]);
        }
    }

    private boolean process(ICombinationRecipe recipe) {
        int extract = recipe.getPowerRate();
        int difference = recipe.getPowerCost() - this.progress;
        if (difference < recipe.getPowerRate()) {
            extract = difference;
        }
        int extracted = this.energy.extractEnergy(extract, false);
        this.progress += extracted;
        return this.progress >= recipe.getPowerCost();
    }

    public Map<BlockPos, ItemStack> getPedestalsWithItems() {
        LinkedHashMap<BlockPos, ItemStack> pedestals = new LinkedHashMap<BlockPos, ItemStack>();
        Level world = this.getLevel();
        int pedestalCount = 0;
        if (world != null) {
            BlockPos pos = this.getBlockPos();
            Iterator positions = BlockPos.betweenClosedStream((BlockPos)pos.offset(-3, 0, -3), (BlockPos)pos.offset(3, 0, 3)).iterator();
            while (positions.hasNext()) {
                BlockPos aoePos = (BlockPos)positions.next();
                BlockEntity tile = world.getBlockEntity(aoePos);
                if (!(tile instanceof PedestalTileEntity)) continue;
                PedestalTileEntity pedestal = (PedestalTileEntity)tile;
                ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                ++pedestalCount;
                if (stack.isEmpty()) continue;
                pedestals.put(aoePos.immutable(), stack);
            }
        }
        this.pedestalCount = pedestalCount;
        return pedestals;
    }

    private <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.getLevel();
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + yOffset;
        double z = (double)pos.getZ() + 0.5;
        level.sendParticles(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.getLevel();
        BlockPos pos = this.getBlockPos();
        double x = (double)pedestalPos.getX() + level.getRandom().nextDouble() * 0.2 + 0.4;
        double y = (double)pedestalPos.getY() + level.getRandom().nextDouble() * 0.2 + 1.4;
        double z = (double)pedestalPos.getZ() + level.getRandom().nextDouble() * 0.2 + 0.4;
        double velX = pos.getX() - pedestalPos.getX();
        double velY = 0.25;
        double velZ = pos.getZ() - pedestalPos.getZ();
        level.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    private boolean shouldSpawnItemParticles() {
        int powerRate;
        int endingPower;
        int powerCost = ((ICombinationRecipe)this.recipe.get()).getPowerCost();
        return this.progress > powerCost - (endingPower = (powerRate = ((ICombinationRecipe)this.recipe.get()).getPowerRate()) * 40);
    }

    private CraftingInput toCraftingInput() {
        return this.recipeInventory.toShapelessCraftingInput();
    }
}

