/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.singularity;

import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModDataComponentTypes;
import com.blakebr0.extendedcrafting.init.ModItems;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class SingularityUtils {
    public static Singularity loadFromJson(ResourceLocation id, JsonObject json) {
        Singularity singularity;
        String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
        JsonArray colors = GsonHelper.getAsJsonArray((JsonObject)json, (String)"colors");
        int materialCount = GsonHelper.getAsInt((JsonObject)json, (String)"materialCount", (int)((Integer)ModConfigs.SINGULARITY_MATERIALS_REQUIRED.get()));
        int overlayColor = Integer.parseInt(colors.get(0).getAsString(), 16);
        int underlayColor = Integer.parseInt(colors.get(1).getAsString(), 16);
        boolean inUltimateSingularity = GsonHelper.getAsBoolean((JsonObject)json, (String)"inUltimateSingularity", (boolean)true);
        JsonObject ing = GsonHelper.getAsJsonObject((JsonObject)json, (String)"ingredient", null);
        if (ing == null) {
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, Ingredient.EMPTY, materialCount, inUltimateSingularity);
        } else if (ing.has("tag")) {
            String tag = ing.get("tag").getAsString();
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, tag, materialCount, inUltimateSingularity);
        } else {
            Ingredient ingredient = (Ingredient)((Pair)Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("ingredient")).getOrThrow()).getFirst();
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, ingredient, materialCount, inUltimateSingularity);
        }
        boolean enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
        singularity.setEnabled(enabled);
        return singularity;
    }

    public static JsonObject writeToJson(Singularity singularity) {
        JsonElement ingredient;
        JsonObject json = new JsonObject();
        json.addProperty("name", singularity.getName());
        JsonArray colors = new JsonArray();
        colors.add(Integer.toHexString(singularity.getOverlayColor() & 0xFFFFFF));
        colors.add(Integer.toHexString(singularity.getUnderlayColor() & 0xFFFFFF));
        json.add("colors", (JsonElement)colors);
        if (singularity.getTag() != null) {
            JsonObject obj = new JsonObject();
            obj.addProperty("tag", singularity.getTag());
            ingredient = obj;
        } else {
            ingredient = (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)singularity.getIngredient()).getOrThrow();
        }
        json.add("ingredient", ingredient);
        if (!singularity.isEnabled()) {
            json.addProperty("enabled", Boolean.valueOf(false));
        }
        return json;
    }

    public static ItemStack getItemForSingularity(Singularity singularity) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SINGULARITY.get());
        stack.set(ModDataComponentTypes.SINGULARITY_ID, (Object)singularity.getId());
        return stack;
    }

    public static Singularity getSingularity(ItemStack stack) {
        ResourceLocation id = (ResourceLocation)stack.get(ModDataComponentTypes.SINGULARITY_ID);
        if (id != null) {
            return SingularityRegistry.getInstance().getSingularityById(id);
        }
        return null;
    }
}

