/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.network.payload;

import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.tileentity.AutoEnderCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoFluxCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SelectRecipePayload(BlockPos pos, int selected) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SelectRecipePayload> TYPE = new CustomPacketPayload.Type(ExtendedCrafting.resource("select_recipe"));
    public static final StreamCodec<FriendlyByteBuf, SelectRecipePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SelectRecipePayload::pos, (StreamCodec)ByteBufCodecs.VAR_INT, SelectRecipePayload::selected, SelectRecipePayload::new);

    public CustomPacketPayload.Type<SelectRecipePayload> type() {
        return TYPE;
    }

    public static void handleServer(SelectRecipePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            BaseInventoryTileEntity crafter;
            Player player = context.player();
            Level level = player.level();
            BlockEntity tile = level.getBlockEntity(payload.pos);
            if (tile instanceof AutoTableTileEntity) {
                AutoTableTileEntity table = (AutoTableTileEntity)tile;
                table.selectRecipe(payload.selected);
            }
            if (tile instanceof AutoEnderCrafterTileEntity) {
                crafter = (AutoEnderCrafterTileEntity)tile;
                crafter.selectRecipe(payload.selected);
            }
            if (tile instanceof AutoFluxCrafterTileEntity) {
                crafter = (AutoFluxCrafterTileEntity)tile;
                crafter.selectRecipe(payload.selected);
            }
        });
    }
}

