/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.network.payload;

import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.tileentity.AutoEnderCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoFluxCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SaveRecipePayload(BlockPos pos, int selected) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SaveRecipePayload> TYPE = new CustomPacketPayload.Type(ExtendedCrafting.resource("save_recipe"));
    public static final StreamCodec<FriendlyByteBuf, SaveRecipePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SaveRecipePayload::pos, (StreamCodec)ByteBufCodecs.VAR_INT, SaveRecipePayload::selected, SaveRecipePayload::new);

    public CustomPacketPayload.Type<SaveRecipePayload> type() {
        return TYPE;
    }

    public static void handleServer(SaveRecipePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            BaseInventoryTileEntity crafter;
            Player player = context.player();
            Level level = player.level();
            BlockEntity tile = level.getBlockEntity(payload.pos);
            if (tile instanceof AutoTableTileEntity) {
                AutoTableTileEntity table = (AutoTableTileEntity)tile;
                if (!table.getRecipeStorage().hasRecipe(payload.selected)) {
                    table.saveRecipe(payload.selected);
                } else {
                    table.deleteRecipe(payload.selected);
                }
            }
            if (tile instanceof AutoEnderCrafterTileEntity) {
                crafter = (AutoEnderCrafterTileEntity)tile;
                if (!crafter.getRecipeStorage().hasRecipe(payload.selected)) {
                    crafter.saveRecipe(payload.selected);
                } else {
                    crafter.deleteRecipe(payload.selected);
                }
            }
            if (tile instanceof AutoFluxCrafterTileEntity) {
                crafter = (AutoFluxCrafterTileEntity)tile;
                if (!crafter.getRecipeStorage().hasRecipe(payload.selected)) {
                    crafter.saveRecipe(payload.selected);
                } else {
                    crafter.deleteRecipe(payload.selected);
                }
            }
        });
    }
}

