/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item.loot;

import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.extendedcrafting.api.component.TableRecipeStorageComponent;
import com.blakebr0.extendedcrafting.crafting.TableRecipeStorage;
import com.blakebr0.extendedcrafting.init.ModDataComponentTypes;
import com.blakebr0.extendedcrafting.init.ModLootItemFunctionTypes;
import com.blakebr0.extendedcrafting.tileentity.AutoEnderCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoFluxCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class SaveRecipeStorageItemFunction
implements LootItemFunction {
    public static final MapCodec<SaveRecipeStorageItemFunction> CODEC = MapCodec.unit((Object)new SaveRecipeStorageItemFunction());

    public LootItemFunctionType<SaveRecipeStorageItemFunction> getType() {
        return (LootItemFunctionType)ModLootItemFunctionTypes.SAVE_RECIPE_STORAGE.get();
    }

    public ItemStack apply(ItemStack stack, LootContext context) {
        BaseInventoryTileEntity crafter;
        AutoTableTileEntity table;
        TableRecipeStorage storage;
        BlockEntity tile = (BlockEntity)context.getParam(LootContextParams.BLOCK_ENTITY);
        ServerLevel level = context.getLevel();
        if (tile instanceof AutoTableTileEntity && (storage = (table = (AutoTableTileEntity)tile).getRecipeStorage()).hasRecipes()) {
            SaveRecipeStorageItemFunction.save(stack, storage, (Level)level);
        }
        if (tile instanceof AutoEnderCrafterTileEntity && (storage = (crafter = (AutoEnderCrafterTileEntity)tile).getRecipeStorage()).hasRecipes()) {
            SaveRecipeStorageItemFunction.save(stack, storage, (Level)level);
        }
        if (tile instanceof AutoFluxCrafterTileEntity && (storage = (crafter = (AutoFluxCrafterTileEntity)tile).getRecipeStorage()).hasRecipes()) {
            SaveRecipeStorageItemFunction.save(stack, storage, (Level)level);
        }
        return stack;
    }

    private static void save(ItemStack stack, TableRecipeStorage storage, Level level) {
        int count = storage.getRecipeCount();
        CompoundTag data = storage.serializeNBT((HolderLookup.Provider)level.registryAccess());
        stack.set(ModDataComponentTypes.TABLE_RECIPE_STORAGE, (Object)new TableRecipeStorageComponent(count, data));
    }
}

