/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting;

import com.blakebr0.cucumber.crafting.ingredient.IngredientWithCount;
import com.blakebr0.cucumber.event.RecipeManagerLoadingEvent;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.crafting.recipe.CompressorRecipe;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityRegistry;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;

public final class DynamicRecipeManager {
    private static final DynamicRecipeManager INSTANCE = new DynamicRecipeManager();

    @SubscribeEvent
    public void onRegisterRecipes(RecipeManagerLoadingEvent event) {
        SingularityRegistry.getInstance().loadSingularities();
        for (Singularity singularity : SingularityRegistry.getInstance().getSingularities()) {
            RecipeHolder<CompressorRecipe> compressorRecipe = DynamicRecipeManager.makeSingularityRecipe(singularity);
            if (compressorRecipe == null) continue;
            event.addRecipe(compressorRecipe);
        }
    }

    public static DynamicRecipeManager getInstance() {
        return INSTANCE;
    }

    private static RecipeHolder<CompressorRecipe> makeSingularityRecipe(Singularity singularity) {
        if (!((Boolean)ModConfigs.SINGULARITY_DEFAULT_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient ingredient = singularity.getIngredient();
        if (ingredient == Ingredient.EMPTY) {
            return null;
        }
        ResourceLocation id = ExtendedCrafting.resource(singularity.getId().getPath() + "_singularity");
        ItemStack result = SingularityUtils.getItemForSingularity(singularity);
        int ingredientCount = singularity.getIngredientCount();
        Item catalystItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)((String)ModConfigs.SINGULARITY_DEFAULT_CATALYST.get())));
        Ingredient catalyst = Ingredient.of((ItemLike[])new ItemLike[]{catalystItem});
        int powerRequired = (Integer)ModConfigs.SINGULARITY_POWER_REQUIRED.get();
        return new RecipeHolder(id, (Recipe)new CompressorRecipe((NonNullList<IngredientWithCount>)NonNullList.of((Object)IngredientWithCount.EMPTY, (Object[])new IngredientWithCount[]{new IngredientWithCount(ingredient.getValues()[0], ingredientCount)}), result, catalyst, powerRequired, (Integer)ModConfigs.COMPRESSOR_POWER_RATE.get()));
    }
}

