/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category;

import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.api.crafting.ICompressorRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class CompressorCraftingCategory
implements IRecipeCategory<RecipeHolder<ICompressorRecipe>> {
    private static final ResourceLocation TEXTURE = ExtendedCrafting.resource("textures/jei/compressor.png");
    public static final RecipeType<RecipeHolder<ICompressorRecipe>> RECIPE_TYPE = RecipeType.createRecipeHolderType((ResourceLocation)ExtendedCrafting.resource("compressor"));
    private final IDrawable background;
    private final IDrawable icon;

    public CompressorCraftingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 149, 78);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.COMPRESSOR.get()));
    }

    public RecipeType<RecipeHolder<ICompressorRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.compressor").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<ICompressorRecipe> recipeHolder, IRecipeSlotsView slots, double mouseX, double mouseY) {
        ICompressorRecipe recipe = (ICompressorRecipe)recipeHolder.value();
        if (mouseX > 1.0 && mouseX < 14.0 && mouseY > 1.0 && mouseY < 78.0) {
            tooltip.add((FormattedText)Formatting.energy((Object)recipe.getPowerCost()));
            tooltip.add((FormattedText)Formatting.energyPerTick((Object)recipe.getPowerRate()));
        }
        if (mouseX > 54.0 && mouseX < 78.0 && mouseY > 58.0 && mouseY < 68.0) {
            tooltip.add((FormattedText)ModTooltips.NUM_ITEMS.args(new Object[]{Formatting.number((Object)recipe.getCount(0))}).color(ChatFormatting.WHITE).build());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ICompressorRecipe> recipeHolder, IFocusGroup focuses) {
        ICompressorRecipe recipe = (ICompressorRecipe)recipeHolder.value();
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        NonNullList inputs = recipe.getIngredients();
        Ingredient catalyst = recipe.getCatalyst();
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        builder.addSlot(RecipeIngredientRole.INPUT, 58, 31).addIngredients((Ingredient)inputs.get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 31, 31).addIngredients(catalyst);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 128, 31).addItemStack(output);
    }
}

