/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.cucumber.crafting.ingredient.IngredientWithCount;
import com.blakebr0.extendedcrafting.api.crafting.ICompressorRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.crafting.recipe.CompressorRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.CompressionCrafting")
@ZenRegister
public final class CompressionCrafting
implements IRecipeManager<ICompressorRecipe> {
    public RecipeType<ICompressorRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.COMPRESSOR.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IIngredient input, int inputCount, IIngredient catalyst, int powerCost) {
        this.addRecipe(name, output, input, inputCount, catalyst, powerCost, (Integer)ModConfigs.COMPRESSOR_POWER_RATE.get());
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IIngredient input, int inputCount, IIngredient catalyst, int powerCost, int powerRate) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        CompressorRecipe recipe = new CompressorRecipe(CompressionCrafting.toInputIngredient(input, inputCount), output.getInternal(), catalyst.asVanillaIngredient(), powerCost, powerRate);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    private static NonNullList<IngredientWithCount> toInputIngredient(IIngredient iingredient, int inputCount) {
        IngredientWithCount ingredient = new IngredientWithCount(iingredient.asVanillaIngredient().getValues()[0], inputCount);
        return NonNullList.of((Object)IngredientWithCount.EMPTY, (Object[])new IngredientWithCount[]{ingredient});
    }
}

