/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.jadecolonies.minecolonies;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.core.tileentities.TileEntityDecorationController;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

class BuildingNameComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"jadecolonies", (String)"colony.hut");
    private static final String OVERRIDE_NAME = "givenName";
    private static final String BUILDING_NAME = UID.toString();
    private static final BuildingNameComponentProvider INSTANCE = new BuildingNameComponentProvider();

    BuildingNameComponentProvider() {
    }

    public static BuildingNameComponentProvider getInstance() {
        return INSTANCE;
    }

    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    public boolean isRequired() {
        return true;
    }

    public int getDefaultPriority() {
        return -3000;
    }

    public void appendServerData(@NotNull CompoundTag compoundTag, @NotNull BlockAccessor blockAccessor) {
        RegistryAccess lookupProvider = blockAccessor.getLevel().registryAccess();
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding entity = (AbstractTileEntityColonyBuilding)blockEntity;
            IBuilding building = entity.getBuilding();
            if (building == null || building instanceof IRSComponent) {
                return;
            }
            String name = building.getCustomName();
            MutableComponent nameLevel = Component.translatable((String)"%s %s", (Object[])new Object[]{Component.translatable((String)building.getBuildingType().getTranslationKey()), Integer.toString(building.getBuildingLevel())});
            if (name.isEmpty()) {
                compoundTag.putString(OVERRIDE_NAME, Component.Serializer.toJson((Component)nameLevel, (HolderLookup.Provider)lookupProvider));
            } else {
                compoundTag.putString(OVERRIDE_NAME, Component.Serializer.toJson((Component)Component.literal((String)name), (HolderLookup.Provider)lookupProvider));
                compoundTag.putString(BUILDING_NAME, Component.Serializer.toJson((Component)nameLevel.withStyle(ChatFormatting.GRAY), (HolderLookup.Provider)lookupProvider));
            }
        } else {
            blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof TileEntityDecorationController) {
                TileEntityDecorationController deco = (TileEntityDecorationController)blockEntity;
                compoundTag.putString(BUILDING_NAME, Component.Serializer.toJson((Component)Component.literal((String)deco.getBlueprintPath()), (HolderLookup.Provider)lookupProvider));
            }
        }
    }

    public void appendTooltip(@NotNull ITooltip tooltip, @NotNull BlockAccessor blockAccessor, @NotNull IPluginConfig pluginConfig) {
        RegistryAccess lookupProvider = blockAccessor.getLevel().registryAccess();
        CompoundTag data = blockAccessor.getServerData();
        if (data.contains(BUILDING_NAME)) {
            MutableComponent name = Component.Serializer.fromJson((String)data.getString(BUILDING_NAME), (HolderLookup.Provider)lookupProvider);
            tooltip.add((Component)name);
        }
    }
}

