/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.item;

import com.mamailes.merrymaking.init.MMBlocks;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DrinkItem
extends ItemNameBlockItem {
    private static final int DRINK_DURATION = 40;

    public DrinkItem(Block block, Item.Properties p_41346_) {
        super(block, p_41346_);
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        super.finishUsingItem(pStack, pLevel, pEntityLiving);
        if (pEntityLiving instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)pEntityLiving;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, pStack);
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!pLevel.isClientSide) {
            pEntityLiving.removeEffect(MobEffects.POISON);
        }
        if (pStack.isEmpty()) {
            return new ItemStack((ItemLike)MMBlocks.MUG.get());
        }
        if (pEntityLiving instanceof Player && !((Player)pEntityLiving).getAbilities().instabuild) {
            ItemStack itemstack = new ItemStack((ItemLike)MMBlocks.MUG.get());
            Player player = (Player)pEntityLiving;
            if (!player.getInventory().add(itemstack)) {
                player.drop(itemstack, false);
            }
        }
        return pStack;
    }

    public int getUseDuration(ItemStack pStack) {
        return 40;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        return ItemUtils.startUsingInstantly((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
    }
}

