/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.mantel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mamailes.happyhallows.init.MMHBlocks;
import com.mamailes.merrymaking.block.deco.base.HorizontalDecoBlock;
import com.mamailes.merrymaking.init.MMBlocks;
import com.mamailes.merrymaking.init.MMItems;
import com.mamailes.merrymaking.util.MMHShapes;
import com.mamailes.merrymaking.util.MerryMakingImplementation;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MantelBlock
extends HorizontalDecoBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_TL;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_TR;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_TC;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_BL;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_BR;
    public static final IntegerProperty SECTION = IntegerProperty.create((String)"section", (int)0, (int)4);
    public static final EnumProperty<DecoType> TYPE = EnumProperty.create((String)"type", DecoType.class);
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    public static final BooleanProperty CORNER = BooleanProperty.create((String)"corner");
    public static final BooleanProperty STOCKING = BooleanProperty.create((String)"stocking");
    private static final ThreadLocal<Boolean> IS_PROCESSING_MANTEL_DESTRUCTION = ThreadLocal.withInitial(() -> false);

    public MantelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)DecoType.EMPTY))).setValue((Property)CORNER, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)STOCKING, (Comparable)Boolean.valueOf(false)));
        this.SHAPES_TL = this.generateTopLeftShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_TR = this.generateTopRightShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_TC = this.generateTopCenterShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_BL = this.generateBottomLeftShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_BR = this.generateBottomRightShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    private ImmutableMap<BlockState, VoxelShape> generateTopLeftShapes(ImmutableList<BlockState> states) {
        VoxelShape[] TOP_LEFT_TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_TOP1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)14.0, (double)0.0, (double)10.0, (double)15.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_TOP2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)10.0, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_MID = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)8.0, (double)0.0, (double)9.0, (double)14.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_MID1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)9.0, (double)8.0, (double)0.0, (double)16.0, (double)14.0, (double)11.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_TOP3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)7.0, (double)0.0, (double)10.0, (double)8.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_TOP4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)10.0, (double)7.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)7.0, (double)14.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_TOP5 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)5.0, (double)0.0, (double)10.0, (double)6.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_LEG = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)1.0, (double)0.0, (double)9.0, (double)5.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TOP_LEFT_LEG_EDGE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)0.0, (double)0.0, (double)10.0, (double)1.0, (double)13.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTL = new ArrayList<VoxelShape>();
            shapesTL.add(TOP_LEFT_TOP[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_TOP1[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_TOP2[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_MID[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_MID1[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_TOP3[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_TOP4[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_BASE[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_TOP5[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_LEG[direction.get2DDataValue()]);
            shapesTL.add(TOP_LEFT_LEG_EDGE[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTL));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateTopRightShapes(ImmutableList<BlockState> states) {
        VoxelShape[] TOP_RIGHT_TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_TOP1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)14.0, (double)0.0, (double)6.0, (double)15.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_TOP2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)6.0, (double)14.0, (double)0.0, (double)15.0, (double)15.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_MID = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)14.0, (double)11.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_MID1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.0, (double)8.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_TOP3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)7.0, (double)0.0, (double)8.0, (double)8.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_TOP4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)6.0, (double)7.0, (double)0.0, (double)15.0, (double)8.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)7.0, (double)14.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_TOP5 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)6.0, (double)5.0, (double)0.0, (double)15.0, (double)6.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_LEG = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.0, (double)1.0, (double)0.0, (double)14.0, (double)5.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TOP_RIGHT_LEG_EDGE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)6.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)13.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTR = new ArrayList<VoxelShape>();
            shapesTR.add(TOP_RIGHT_TOP[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_TOP1[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_TOP2[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_MID[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_MID1[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_TOP3[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_TOP4[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_BASE[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_TOP5[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_LEG[direction.get2DDataValue()]);
            shapesTR.add(TOP_RIGHT_LEG_EDGE[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTR));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateTopCenterShapes(ImmutableList<BlockState> states) {
        VoxelShape[] TC_TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Direction.SOUTH));
        VoxelShape[] TC_TOP1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TC_MID = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)14.0, (double)11.0), Direction.SOUTH));
        VoxelShape[] TC_TOP2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] TC_B = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)7.0, (double)14.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTC = new ArrayList<VoxelShape>();
            shapesTC.add(TC_TOP[direction.get2DDataValue()]);
            shapesTC.add(TC_TOP1[direction.get2DDataValue()]);
            shapesTC.add(TC_MID[direction.get2DDataValue()]);
            shapesTC.add(TC_TOP2[direction.get2DDataValue()]);
            shapesTC.add(TC_B[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTC));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateBottomLeftShapes(ImmutableList<BlockState> states) {
        VoxelShape[] BL_BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)4.0, (double)14.0), Direction.SOUTH));
        VoxelShape[] BL_EDGE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)4.0, (double)0.0, (double)10.0, (double)5.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] BL_LEG = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)5.0, (double)0.0, (double)9.0, (double)16.0, (double)12.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesBL = new ArrayList<VoxelShape>();
            shapesBL.add(BL_BASE[direction.get2DDataValue()]);
            shapesBL.add(BL_EDGE[direction.get2DDataValue()]);
            shapesBL.add(BL_LEG[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesBL));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateBottomRightShapes(ImmutableList<BlockState> states) {
        VoxelShape[] BR_BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)14.0), Direction.SOUTH));
        VoxelShape[] BR_EDGE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)6.0, (double)4.0, (double)0.0, (double)15.0, (double)5.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] BR_LEG = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.0, (double)5.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesBR = new ArrayList<VoxelShape>();
            shapesBR.add(BR_BASE[direction.get2DDataValue()]);
            shapesBR.add(BR_EDGE[direction.get2DDataValue()]);
            shapesBR.add(BR_LEG[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesBR));
        }
        return builder.build();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)SECTION)) {
            case 0 -> Objects.requireNonNull((VoxelShape)this.SHAPES_BL.get((Object)state));
            case 1 -> Objects.requireNonNull((VoxelShape)this.SHAPES_TL.get((Object)state));
            case 2 -> Objects.requireNonNull((VoxelShape)this.SHAPES_TC.get((Object)state));
            case 3 -> Objects.requireNonNull((VoxelShape)this.SHAPES_TR.get((Object)state));
            default -> Objects.requireNonNull((VoxelShape)this.SHAPES_BR.get((Object)state));
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SECTION});
        builder.add(new Property[]{DIRECTION});
        builder.add(new Property[]{TYPE});
        builder.add(new Property[]{LIT});
        builder.add(new Property[]{CORNER});
        builder.add(new Property[]{STOCKING});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        Level level = context.getLevel();
        BlockPos centerPos = context.getClickedPos();
        BlockPos leg_l_pos = context.getClickedPos().relative(direction.getCounterClockWise());
        BlockPos leg_r_pos = context.getClickedPos().relative(direction.getClockWise());
        BlockPos top_l_pos = context.getClickedPos().above().relative(direction.getCounterClockWise());
        BlockPos top_m_pos = context.getClickedPos().above();
        BlockPos top_r_pos = context.getClickedPos().above().relative(direction.getClockWise());
        if (level.getBlockState(centerPos).canBeReplaced(context) && level.getBlockState(leg_l_pos).canBeReplaced(context) && level.getBlockState(leg_r_pos).canBeReplaced(context) && level.getBlockState(top_l_pos).canBeReplaced(context) && level.getBlockState(top_m_pos).canBeReplaced(context) && level.getBlockState(top_r_pos).canBeReplaced(context)) {
            return (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)direction);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack p_49851_) {
        Direction direction = (Direction)state.getValue((Property)DIRECTION);
        BlockPos centerPos = pos.relative(direction);
        BlockPos leg_l_pos = pos.relative(direction.getCounterClockWise());
        BlockPos leg_r_pos = pos.relative(direction.getClockWise());
        BlockPos top_l_pos = pos.above().relative(direction.getCounterClockWise());
        BlockPos top_m_pos = pos.above();
        BlockPos top_r_pos = pos.above().relative(direction.getClockWise());
        if (!level.isClientSide()) {
            level.setBlockAndUpdate(leg_l_pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)SECTION, (Comparable)Integer.valueOf(0))).setValue((Property)DIRECTION, (Comparable)direction));
            level.setBlockAndUpdate(top_l_pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)SECTION, (Comparable)Integer.valueOf(1))).setValue((Property)DIRECTION, (Comparable)direction));
            level.setBlockAndUpdate(top_m_pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)SECTION, (Comparable)Integer.valueOf(2))).setValue((Property)DIRECTION, (Comparable)direction));
            level.setBlockAndUpdate(top_r_pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)SECTION, (Comparable)Integer.valueOf(3))).setValue((Property)DIRECTION, (Comparable)direction));
            level.setBlockAndUpdate(leg_r_pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)SECTION, (Comparable)Integer.valueOf(4))).setValue((Property)DIRECTION, (Comparable)direction));
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        super.setPlacedBy(level, pos, state, entity, p_49851_);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack deco = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            if (deco.getItem() == MMItems.STOCKING.get() && !((Boolean)state.getValue((Property)STOCKING)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STOCKING, (Comparable)Boolean.valueOf(true)));
                deco.shrink(1);
                return ItemInteractionResult.CONSUME;
            }
            if (deco.getItem() == ((Block)MMBlocks.GARLAND_HORIZONTAL.get()).asItem()) {
                if (state.getValue(TYPE) == DecoType.EMPTY) {
                    if ((Integer)state.getValue((Property)SECTION) == 0 || (Integer)state.getValue((Property)SECTION) == 4) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND)));
                        deco.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND)));
                    deco.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                if (((Integer)state.getValue((Property)SECTION) == 1 || (Integer)state.getValue((Property)SECTION) == 3) && state.getValue(TYPE) == DecoType.GARLAND) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(true)));
                    deco.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
            }
            if (deco.getItem() == ((Block)MMBlocks.GARLAND_HORIZONTAL_LIGHTS_WHITE.get()).asItem()) {
                if (state.getValue(TYPE) == DecoType.EMPTY) {
                    if ((Integer)state.getValue((Property)SECTION) == 0 || (Integer)state.getValue((Property)SECTION) == 4) {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_WHITE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                        deco.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_WHITE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    deco.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                if (((Integer)state.getValue((Property)SECTION) == 1 || (Integer)state.getValue((Property)SECTION) == 3) && state.getValue(TYPE) == DecoType.GARLAND_WHITE) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(true)));
                    deco.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
            }
            if (deco.getItem() == ((Block)MMBlocks.GARLAND_HORIZONTAL_LIGHTS_MULTI.get()).asItem()) {
                if (state.getValue(TYPE) == DecoType.EMPTY) {
                    if ((Integer)state.getValue((Property)SECTION) == 0 || (Integer)state.getValue((Property)SECTION) == 4) {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_MULTI))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                        deco.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_MULTI))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    deco.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                if (((Integer)state.getValue((Property)SECTION) == 1 || (Integer)state.getValue((Property)SECTION) == 3) && state.getValue(TYPE) == DecoType.GARLAND_MULTI) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(true)));
                    deco.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
            }
            if (MerryMakingImplementation.HAPPY_HALLOWS_LOADED) {
                if (deco.getItem() == ((Block)MMHBlocks.PUMPKIN_GARLAND.get()).asItem()) {
                    if (state.getValue(TYPE) == DecoType.EMPTY) {
                        if ((Integer)state.getValue((Property)SECTION) == 0 || (Integer)state.getValue((Property)SECTION) == 4 || (Integer)state.getValue((Property)SECTION) == 2) {
                            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_PUMPKIN))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                            deco.shrink(1);
                            return ItemInteractionResult.CONSUME;
                        }
                        if (!((Integer)state.getValue((Property)SECTION) != 1 && (Integer)state.getValue((Property)SECTION) != 3 || ((Boolean)state.getValue((Property)CORNER)).booleanValue())) {
                            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_PUMPKIN))).setValue((Property)CORNER, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                            deco.shrink(1);
                            return ItemInteractionResult.CONSUME;
                        }
                    }
                    if (((Integer)state.getValue((Property)SECTION) == 1 || (Integer)state.getValue((Property)SECTION) == 3) && state.getValue(TYPE) == DecoType.GARLAND_PUMPKIN) {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                        deco.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                }
                if (deco.getItem() == ((Block)MMHBlocks.SKULL_GARLAND.get()).asItem()) {
                    if (state.getValue(TYPE) == DecoType.EMPTY) {
                        if ((Integer)state.getValue((Property)SECTION) == 0 || (Integer)state.getValue((Property)SECTION) == 4 || (Integer)state.getValue((Property)SECTION) == 2) {
                            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_SKULL))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                            deco.shrink(1);
                            return ItemInteractionResult.CONSUME;
                        }
                        if (!((Integer)state.getValue((Property)SECTION) != 1 && (Integer)state.getValue((Property)SECTION) != 3 || ((Boolean)state.getValue((Property)CORNER)).booleanValue())) {
                            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_SKULL))).setValue((Property)CORNER, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                            deco.shrink(1);
                            return ItemInteractionResult.CONSUME;
                        }
                    }
                    if (((Integer)state.getValue((Property)SECTION) == 1 || (Integer)state.getValue((Property)SECTION) == 3) && state.getValue(TYPE) == DecoType.GARLAND_SKULL) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(true)));
                        deco.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                }
                if (deco.getItem() == ((Block)MMHBlocks.COBWEB_GARLAND.get()).asItem()) {
                    if (state.getValue(TYPE) == DecoType.EMPTY) {
                        if ((Integer)state.getValue((Property)SECTION) == 0 || (Integer)state.getValue((Property)SECTION) == 4 || (Integer)state.getValue((Property)SECTION) == 2) {
                            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_WEB))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                            deco.shrink(1);
                            return ItemInteractionResult.CONSUME;
                        }
                        if (!((Integer)state.getValue((Property)SECTION) != 1 && (Integer)state.getValue((Property)SECTION) != 3 || ((Boolean)state.getValue((Property)CORNER)).booleanValue())) {
                            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_WEB))).setValue((Property)CORNER, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                            deco.shrink(1);
                            return ItemInteractionResult.CONSUME;
                        }
                    }
                    if (((Integer)state.getValue((Property)SECTION) == 1 || (Integer)state.getValue((Property)SECTION) == 3) && state.getValue(TYPE) == DecoType.GARLAND_WEB) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(true)));
                        deco.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                }
                if (deco.getItem() == ((Block)MMHBlocks.BAT_GARLAND.get()).asItem()) {
                    if (state.getValue(TYPE) == DecoType.EMPTY) {
                        if ((Integer)state.getValue((Property)SECTION) == 0 || (Integer)state.getValue((Property)SECTION) == 4 || (Integer)state.getValue((Property)SECTION) == 2) {
                            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_BAT))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                            deco.shrink(1);
                            return ItemInteractionResult.CONSUME;
                        }
                        if (!((Integer)state.getValue((Property)SECTION) != 1 && (Integer)state.getValue((Property)SECTION) != 3 || ((Boolean)state.getValue((Property)CORNER)).booleanValue())) {
                            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.GARLAND_BAT))).setValue((Property)CORNER, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                            deco.shrink(1);
                            return ItemInteractionResult.CONSUME;
                        }
                    }
                    if (((Integer)state.getValue((Property)SECTION) == 1 || (Integer)state.getValue((Property)SECTION) == 3) && state.getValue(TYPE) == DecoType.GARLAND_BAT) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(true)));
                        deco.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (((Boolean)state.getValue((Property)STOCKING)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STOCKING, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMItems.STOCKING.get()));
            } else if (state.getValue(TYPE) == DecoType.GARLAND && ((Boolean)state.getValue((Property)CORNER)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMBlocks.GARLAND_HORIZONTAL.get()));
            } else if (state.getValue(TYPE) == DecoType.GARLAND) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.EMPTY))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMBlocks.GARLAND_HORIZONTAL.get()));
            } else if (state.getValue(TYPE) == DecoType.GARLAND_WHITE && ((Boolean)state.getValue((Property)CORNER)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMBlocks.GARLAND_HORIZONTAL_LIGHTS_WHITE.get()));
            } else if (state.getValue(TYPE) == DecoType.GARLAND_WHITE) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.EMPTY))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMBlocks.GARLAND_HORIZONTAL_LIGHTS_WHITE.get()));
            } else if (state.getValue(TYPE) == DecoType.GARLAND_MULTI && ((Boolean)state.getValue((Property)CORNER)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMBlocks.GARLAND_HORIZONTAL_LIGHTS_MULTI.get()));
            } else if (state.getValue(TYPE) == DecoType.GARLAND_MULTI) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.EMPTY))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMBlocks.GARLAND_HORIZONTAL_LIGHTS_MULTI.get()));
            }
            if (MerryMakingImplementation.HAPPY_HALLOWS_LOADED) {
                if (state.getValue(TYPE) == DecoType.GARLAND_PUMPKIN && ((Boolean)state.getValue((Property)CORNER)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(false)));
                    player.addItem(new ItemStack((ItemLike)MMHBlocks.PUMPKIN_GARLAND.get()));
                } else if (state.getValue(TYPE) == DecoType.GARLAND_PUMPKIN) {
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.EMPTY))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                    player.addItem(new ItemStack((ItemLike)MMHBlocks.PUMPKIN_GARLAND.get()));
                } else if (state.getValue(TYPE) == DecoType.GARLAND_SKULL && ((Boolean)state.getValue((Property)CORNER)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(false)));
                    player.addItem(new ItemStack((ItemLike)MMHBlocks.SKULL_GARLAND.get()));
                } else if (state.getValue(TYPE) == DecoType.GARLAND_SKULL) {
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.EMPTY))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                    player.addItem(new ItemStack((ItemLike)MMHBlocks.SKULL_GARLAND.get()));
                } else if (state.getValue(TYPE) == DecoType.GARLAND_WEB && ((Boolean)state.getValue((Property)CORNER)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(false)));
                    player.addItem(new ItemStack((ItemLike)MMHBlocks.COBWEB_GARLAND.get()));
                } else if (state.getValue(TYPE) == DecoType.GARLAND_WEB) {
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.EMPTY))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                    player.addItem(new ItemStack((ItemLike)MMHBlocks.COBWEB_GARLAND.get()));
                } else if (state.getValue(TYPE) == DecoType.GARLAND_BAT && ((Boolean)state.getValue((Property)CORNER)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf(false)));
                    player.addItem(new ItemStack((ItemLike)MMHBlocks.BAT_GARLAND.get()));
                } else if (state.getValue(TYPE) == DecoType.GARLAND_BAT) {
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)DecoType.EMPTY))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                    player.addItem(new ItemStack((ItemLike)MMHBlocks.BAT_GARLAND.get()));
                }
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level.isClientSide()) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        if (IS_PROCESSING_MANTEL_DESTRUCTION.get().booleanValue()) {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            if (willHarvest) {
                MantelBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)state.getBlock()));
            }
            return true;
        }
        IS_PROCESSING_MANTEL_DESTRUCTION.set(true);
        try {
            BlockPos brokenPos = pos;
            BlockState brokenState = state;
            int brokenSection = (Integer)brokenState.getValue((Property)SECTION);
            Direction currentDirection = (Direction)brokenState.getValue((Property)DIRECTION);
            BlockPos originalClickPos = null;
            switch (brokenSection) {
                case 0: {
                    originalClickPos = brokenPos.relative(currentDirection.getClockWise());
                    break;
                }
                case 1: {
                    originalClickPos = brokenPos.below().relative(currentDirection.getClockWise());
                    break;
                }
                case 2: {
                    originalClickPos = brokenPos.below();
                    break;
                }
                case 3: {
                    originalClickPos = brokenPos.below().relative(currentDirection.getCounterClockWise());
                    break;
                }
                case 4: {
                    originalClickPos = brokenPos.relative(currentDirection.getCounterClockWise());
                    break;
                }
                default: {
                    boolean bl = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
                    return bl;
                }
            }
            BlockPos sectionZeroPos = originalClickPos.relative(currentDirection.getCounterClockWise());
            if (originalClickPos == null || !(level.getBlockState(sectionZeroPos).getBlock() instanceof MantelBlock)) {
                boolean bl = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
                return bl;
            }
            ArrayList<BlockPos> mantelParts = new ArrayList<BlockPos>();
            mantelParts.add(originalClickPos.relative(currentDirection.getCounterClockWise()));
            mantelParts.add(originalClickPos.above().relative(currentDirection.getCounterClockWise()));
            mantelParts.add(originalClickPos.above());
            mantelParts.add(originalClickPos.above().relative(currentDirection.getClockWise()));
            mantelParts.add(originalClickPos.relative(currentDirection.getClockWise()));
            if (MerryMakingImplementation.HAPPY_HALLOWS_LOADED) {
                for (BlockPos partPos : mantelParts) {
                    BlockState partState = level.getBlockState(partPos);
                    if (!(partState.getBlock() instanceof MantelBlock) || partState.getValue((Property)DIRECTION) != currentDirection) continue;
                    DecoType partDecoType = (DecoType)((Object)partState.getValue(TYPE));
                    boolean partIsCorner = (Boolean)partState.getValue((Property)CORNER);
                    if (partDecoType == DecoType.EMPTY) continue;
                    ItemStack garlandToDrop = ItemStack.EMPTY;
                    int quantity = 1;
                    if (partDecoType == DecoType.GARLAND_PUMPKIN) {
                        garlandToDrop = new ItemStack((ItemLike)MMHBlocks.PUMPKIN_GARLAND.get());
                    } else if (partDecoType == DecoType.GARLAND_SKULL) {
                        garlandToDrop = new ItemStack((ItemLike)MMHBlocks.SKULL_GARLAND.get());
                    } else if (partDecoType == DecoType.GARLAND_WEB) {
                        garlandToDrop = new ItemStack((ItemLike)MMHBlocks.COBWEB_GARLAND.get());
                    } else if (partDecoType == DecoType.GARLAND_BAT) {
                        garlandToDrop = new ItemStack((ItemLike)MMHBlocks.BAT_GARLAND.get());
                    }
                    if (partIsCorner) {
                        quantity = 2;
                    }
                    if (garlandToDrop.isEmpty()) continue;
                    MantelBlock.popResource((Level)level, (BlockPos)partPos, (ItemStack)new ItemStack((ItemLike)garlandToDrop.getItem(), quantity));
                    level.setBlockAndUpdate(partPos, (BlockState)((BlockState)((BlockState)partState.setValue(TYPE, (Comparable)((Object)DecoType.EMPTY))).setValue((Property)CORNER, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                }
            }
            for (BlockPos partPos : mantelParts) {
                if (!(level.getBlockState(partPos).getBlock() instanceof MantelBlock) || level.getBlockState(partPos).getValue((Property)DIRECTION) != currentDirection) continue;
                level.destroyBlock(partPos, true);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            IS_PROCESSING_MANTEL_DESTRUCTION.set(false);
        }
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public static enum DecoType implements StringRepresentable
    {
        EMPTY("empty"),
        GARLAND("garland"),
        GARLAND_WHITE("garland_white"),
        GARLAND_MULTI("garland_multi"),
        GARLAND_WEB("garland_web"),
        GARLAND_SKULL("garland_skull"),
        GARLAND_PUMPKIN("garland_pumpkin"),
        GARLAND_BAT("garland_bat");

        final String serializedName;

        private DecoType(String name) {
            this.serializedName = name;
        }

        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return this.serializedName;
        }
    }
}

