/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.util;

import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.ItemStackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class WorldInteractionUtil {
    private WorldInteractionUtil() {
    }

    public static InteractionResult tryMilkLivingEntity(ItemStack itemStack, LivingEntity entity, Player player, InteractionHand interactionHand) {
        if (!entity.getType().is(BucketLibTags.EntityTypes.MILKABLE)) {
            return InteractionResult.PASS;
        }
        player.setItemInHand(interactionHand, new ItemStack((ItemLike)Items.BUCKET));
        boolean previousInstabuildValue = player.getAbilities().instabuild;
        player.getAbilities().instabuild = false;
        InteractionResult result = player.interactOn((Entity)entity, interactionHand);
        player.getAbilities().instabuild = previousInstabuildValue;
        if (result.consumesAction()) {
            itemStack = ItemUtils.createFilledResult((ItemStack)itemStack.copy(), (Player)player, (ItemStack)BucketLibUtil.addMilk(ItemStackUtil.copyStackWithSize(itemStack, 1)));
        }
        player.setItemInHand(interactionHand, itemStack);
        return result;
    }

    public static InteractionResultHolder<ItemStack> tryPickupFromCauldron(Level level, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        if (level.isClientSide()) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockPos hitBlockPos = blockHitResult.getBlockPos();
        BlockState hitBlockState = level.getBlockState(hitBlockPos);
        Block hitBlock = hitBlockState.getBlock();
        if (hitBlock instanceof AbstractCauldronBlock) {
            AbstractCauldronBlock cauldronBlock = (AbstractCauldronBlock)hitBlock;
            Item item = itemstack.getItem();
            if (item instanceof UniversalBucketItem) {
                UniversalBucketItem bucketItem = (UniversalBucketItem)item;
                if (BucketLibUtil.isEmpty(itemstack) && (cauldronBlock == Blocks.LAVA_CAULDRON && bucketItem.canHoldFluid((Fluid)Fluids.LAVA) || cauldronBlock == Blocks.WATER_CAULDRON && bucketItem.canHoldFluid((Fluid)Fluids.WATER) || cauldronBlock == Blocks.POWDER_SNOW_CAULDRON && bucketItem.canHoldBlock(Blocks.POWDER_SNOW))) {
                    ItemStack stack = new ItemStack((ItemLike)Items.BUCKET);
                    player.setItemInHand(interactionHand, stack);
                    boolean previousInstabuildValue = player.getAbilities().instabuild;
                    player.getAbilities().instabuild = false;
                    ItemInteractionResult interactionResult = hitBlockState.useItemOn(stack, level, player, interactionHand, blockHitResult);
                    player.getAbilities().instabuild = previousInstabuildValue;
                    ItemStack resultItemStack = player.getItemInHand(interactionHand);
                    player.setItemInHand(interactionHand, itemstack);
                    if (interactionResult.consumesAction()) {
                        if (resultItemStack.getItem() == Items.POWDER_SNOW_BUCKET) {
                            return new InteractionResultHolder(interactionResult.result(), (Object)ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)BucketLibUtil.addBlock(ItemStackUtil.copyStackWithSize(itemstack, 1), Blocks.POWDER_SNOW)));
                        }
                        return new InteractionResultHolder(interactionResult.result(), (Object)ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)BucketLibUtil.addFluid(ItemStackUtil.copyStackWithSize(itemstack, 1), Services.FLUID.getContainedFluid(resultItemStack))));
                    }
                }
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public static InteractionResultHolder<ItemStack> tryPlaceIntoCauldron(Level level, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        BlockPos hitBlockPos = blockHitResult.getBlockPos();
        BlockState hitBlockState = level.getBlockState(hitBlockPos);
        Block hitBlock = hitBlockState.getBlock();
        if (hitBlock instanceof AbstractCauldronBlock) {
            AbstractCauldronBlock cauldronBlock = (AbstractCauldronBlock)hitBlock;
            if (itemstack.getItem() instanceof UniversalBucketItem && cauldronBlock == Blocks.CAULDRON && !BucketLibUtil.containsEntityType(itemstack)) {
                ServerLevel serverLevel;
                Fluid bucketFluid = BucketLibUtil.getFluid(itemstack);
                Block bucketBlock = BucketLibUtil.getBlock(itemstack);
                ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
                if (bucketFluid == Fluids.LAVA || bucketFluid == Fluids.WATER) {
                    ItemStack stack = new ItemStack((ItemLike)bucketFluid.getBucket());
                    player.setItemInHand(interactionHand, stack);
                    boolean previousInstabuildValue = player.getAbilities().instabuild;
                    player.getAbilities().instabuild = false;
                    ItemInteractionResult interactionResult = hitBlockState.useItemOn(stack, level, player, interactionHand, blockHitResult);
                    player.getAbilities().instabuild = previousInstabuildValue;
                    player.setItemInHand(interactionHand, itemstack);
                    if (interactionResult.consumesAction()) {
                        return new InteractionResultHolder(interactionResult.result(), (Object)BucketLibUtil.createEmptyResult(itemstack, player, BucketLibUtil.removeFluid(itemstack, serverLevel, player), interactionHand, true));
                    }
                } else if (bucketBlock == Blocks.POWDER_SNOW) {
                    ItemStack stack = new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET);
                    player.setItemInHand(interactionHand, stack);
                    boolean previousInstabuildValue = player.getAbilities().instabuild;
                    player.getAbilities().instabuild = false;
                    ItemInteractionResult interactionResult = hitBlockState.useItemOn(stack, level, player, interactionHand, blockHitResult);
                    player.getAbilities().instabuild = previousInstabuildValue;
                    player.setItemInHand(interactionHand, itemstack);
                    if (interactionResult.consumesAction()) {
                        return new InteractionResultHolder(interactionResult.result(), (Object)BucketLibUtil.createEmptyResult(itemstack, player, BucketLibUtil.removeBlock(itemstack, serverLevel, player, true), interactionHand, true));
                    }
                }
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

