/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib;

import de.cech12.bucketlib.CommonLoader;
import de.cech12.bucketlib.api.BucketLibComponents;
import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.crafting.BlockIngredient;
import de.cech12.bucketlib.api.crafting.EmptyIngredient;
import de.cech12.bucketlib.api.crafting.EntityIngredient;
import de.cech12.bucketlib.api.crafting.FluidIngredient;
import de.cech12.bucketlib.api.crafting.MilkIngredient;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.item.UniversalBucketDispenseBehaviour;
import de.cech12.bucketlib.item.UniversalBucketFluidHandler;
import de.cech12.bucketlib.item.crafting.BucketFillingShapedRecipe;
import de.cech12.bucketlib.item.crafting.BucketFillingShapelessRecipe;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bucketlib")
public class BucketLibMod {
    public static DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"bucketlib");
    public static DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"bucketlib");
    public static DeferredRegister<IngredientType<?>> INGREDIENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.INGREDIENT_TYPES, (String)"bucketlib");
    public static DeferredHolder<DataComponentType<?>, DataComponentType<SimpleFluidContent>> FLUID_COMPONENT = DATA_COMPONENT_TYPES.register(BucketLibComponents.FLUID_LOCATION.getPath(), () -> new DataComponentType.Builder().persistent(SimpleFluidContent.CODEC).networkSynchronized(SimpleFluidContent.STREAM_CODEC).build());
    private static final Logger LOGGER;
    private static final List<UniversalBucketItem> buckets;

    public BucketLibMod(IEventBus eventBus) {
        CommonLoader.init();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::addItemsToTabs);
        DATA_COMPONENT_TYPES.register(eventBus);
        RECIPE_SERIALIZERS.register(eventBus);
        INGREDIENT_TYPES.register(eventBus);
    }

    public static List<UniversalBucketItem> getRegisteredBuckets() {
        return Collections.unmodifiableList(buckets);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BucketLibTags.init();
    }

    public static void processRegistration(RegisterCapabilitiesEvent event, ResourceLocation bucketLocation) {
        if (bucketLocation != null) {
            Optional bucketItem = BuiltInRegistries.ITEM.getOptional(bucketLocation);
            if (bucketItem.isEmpty()) {
                LOGGER.info("Bucket could not be registered. The given ResourceLocation \"{}\" does not match any registered item in Forge registry.", (Object)bucketLocation);
                return;
            }
            Object t = bucketItem.get();
            if (t instanceof UniversalBucketItem) {
                UniversalBucketItem bucket = (UniversalBucketItem)((Object)t);
                BucketLibMod.registerBucket(event, bucket);
            } else {
                LOGGER.info("Bucket could not be registered. The item \"{}\" is not a {}.", (Object)bucketLocation, (Object)UniversalBucketItem.class.getName());
            }
        } else {
            LOGGER.warn("Bucket could not be registered. The message supplier of the IMCMessage does not contain a ResourceLocation");
        }
    }

    private static void registerBucket(RegisterCapabilitiesEvent event, UniversalBucketItem bucket) {
        buckets.add(bucket);
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new UniversalBucketFluidHandler((ItemStack)stack), new ItemLike[]{bucket});
        DispenserBlock.registerBehavior((ItemLike)bucket, (DispenseItemBehavior)UniversalBucketDispenseBehaviour.getInstance());
        if (FMLEnvironment.dist.isClient()) {
            Minecraft.getInstance().getItemColors().register((stack, layer) -> {
                Fluid fluid;
                if (layer == 0 && bucket.isDyeable()) {
                    return DyedItemColor.getOrDefault((ItemStack)stack, (int)bucket.getDefaultColor());
                }
                if (layer == 1 && (fluid = Services.FLUID.getContainedFluid(stack)) != Fluids.EMPTY) {
                    return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(new FluidStack(fluid, 1000));
                }
                return -1;
            }, new ItemLike[]{bucket});
        }
    }

    private void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        buckets.forEach(bucket -> {
            if (event.getTabKey() == bucket.getCreativeTab()) {
                ItemStack emptyBucket = new ItemStack((ItemLike)bucket);
                event.accept(emptyBucket);
                for (Fluid fluid : BuiltInRegistries.FLUID) {
                    if (fluid == Fluids.EMPTY || NeoForgeMod.MILK.isBound() && ((Fluid)NeoForgeMod.MILK.get()).isSame(fluid) || !bucket.canHoldFluid(fluid)) continue;
                    event.accept(BucketLibUtil.addFluid(emptyBucket, fluid));
                }
                event.accept(BucketLibUtil.addMilk(emptyBucket));
                for (RegistryUtil.BucketEntity bucketEntity : RegistryUtil.getBucketEntities()) {
                    if (!bucket.canHoldEntity(bucketEntity.entityType()) || !bucket.canHoldFluid(bucketEntity.fluid())) continue;
                    ItemStack filledBucket = BucketLibUtil.addFluid(emptyBucket, bucketEntity.fluid());
                    filledBucket = BucketLibUtil.addEntityType(filledBucket, bucketEntity.entityType());
                    event.accept(filledBucket);
                }
                for (RegistryUtil.BucketBlock bucketBlock : RegistryUtil.getBucketBlocks()) {
                    if (!bucket.canHoldBlock(bucketBlock.block())) continue;
                    event.accept(BucketLibUtil.addBlock(emptyBucket, bucketBlock.block()));
                }
            }
        });
    }

    static {
        DATA_COMPONENT_TYPES.register(BucketLibComponents.BUCKET_CONTENT_LOCATION.getPath(), () -> BucketLibComponents.BUCKET_CONTENT);
        RECIPE_SERIALIZERS.register("bucket_filling_shaped", () -> BucketFillingShapedRecipe.Serializer.INSTANCE);
        RECIPE_SERIALIZERS.register("bucket_filling_shapeless", () -> BucketFillingShapelessRecipe.Serializer.INSTANCE);
        INGREDIENT_TYPES.register("block", () -> BlockIngredient.TYPE);
        INGREDIENT_TYPES.register("empty", () -> EmptyIngredient.TYPE);
        INGREDIENT_TYPES.register("entity", () -> EntityIngredient.TYPE);
        INGREDIENT_TYPES.register("fluid", () -> FluidIngredient.TYPE);
        INGREDIENT_TYPES.register("milk", () -> MilkIngredient.TYPE);
        LOGGER = LogManager.getLogger();
        buckets = new ArrayList<UniversalBucketItem>();
    }
}

