/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.util.inventory.portable;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PortableGUIContainerMenu
extends AbstractContainerMenu {
    private final AbstractContainerMenu originalMenu;
    private final BlockPos blockPos;
    private final Player player;

    public PortableGUIContainerMenu(AbstractContainerMenu originalMenu, BlockPos blockPos, Player player) {
        super(originalMenu.getType(), originalMenu.containerId);
        this.originalMenu = originalMenu;
        this.blockPos = blockPos;
        this.player = player;
        for (int i = 0; i < originalMenu.slots.size(); ++i) {
            this.addSlot((Slot)originalMenu.slots.get(i));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void slotsChanged(Container container) {
        this.originalMenu.slotsChanged(container);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return this.originalMenu.quickMoveStack(player, index);
    }

    public void removed(Player player) {
        this.originalMenu.removed(player);
    }

    public void broadcastChanges() {
        BlockEntity blockEntity;
        super.broadcastChanges();
        if (!this.player.level().isClientSide && (blockEntity = this.player.level().getBlockEntity(this.blockPos)) instanceof BlockEntity) {
            BlockEntity blockEntity2 = blockEntity;
            blockEntity2.setChanged();
            ServerPlayer serverPlayer = (ServerPlayer)this.player;
            Packet updatePacket = blockEntity2.getUpdatePacket();
            if (updatePacket != null) {
                serverPlayer.connection.send(updatePacket);
            }
        }
    }

    public void sendAllDataToRemote() {
        this.originalMenu.sendAllDataToRemote();
    }
}

