/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.custom;

import com.benbenlaw.opolisutilities.networking.payload.SmartCraftingRecipeClickPayload;
import com.benbenlaw.opolisutilities.screen.custom.SmartCraftingMenu;
import com.benbenlaw.opolisutilities.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.neoforge.network.PacketDistributor;

@Deprecated(since="4.12.2", forRemoval=true)
public class SmartCraftingScreen
extends AbstractContainerScreen<SmartCraftingMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/smart_crafting_table.png");
    private static final int TOOLTIP_SIZE = 62;
    private static final ResourceLocation CRAFTING_TOOLTIP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/smart_crafting_table_render.png");
    static final ResourceLocation SCROLL_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/interface_scroll.png");
    private List<CraftingRecipe> recipes = Collections.emptyList();
    private List<RecipeHolder<CraftingRecipe>> clientRecipes = Collections.emptyList();
    private static final int ICON_SIZE = 16;
    private static final int ICON_SPACING = 17;
    private static final int VISIBLE_ROWS = 3;
    private static final int VISIBLE_COLS = 8;
    private static final int SCROLLBAR_WIDTH = 12;
    private static final int SCROLLBAR_HEIGHT = 54;
    private static final int SCROLLBAR_X_OFFSET = 154;
    private static final int SCROLLBAR_Y_OFFSET = 15;
    private int hoveredRecipeIndex = -1;
    private int scrollOffset = 0;
    private boolean isDraggingScrollbar = false;
    private static final int COLUMNS = 8;
    public static int visibleRows = 3;
    private final int itemsPerPage = 8 * visibleRows;
    private EditBox searchBox;
    private String lastSearchText = "";
    private List<RecipeHolder<CraftingRecipe>> filteredRecipes = Collections.emptyList();
    private int dragOffsetY = 0;

    public void setClientRecipes(List<RecipeHolder<CraftingRecipe>> recipes) {
        this.clientRecipes = recipes;
        this.updateFilteredRecipes();
    }

    public SmartCraftingScreen(SmartCraftingMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2 + 8;
        int y = (this.height - this.imageHeight) / 2 - 14;
        this.searchBox = new EditBox(this.font, x, y, 141, 15, (Component)Component.literal((String)"Search..."));
        this.searchBox.setMaxLength(50);
        this.searchBox.setResponder(this::onSearchTextChanged);
        this.searchBox.setFocused(true);
        this.searchBox.setBordered(true);
        this.searchBox.setVisible(true);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.updateFilteredRecipes();
    }

    private void onSearchTextChanged(String text) {
        this.lastSearchText = text.toLowerCase();
        this.updateFilteredRecipes();
    }

    private void updateFilteredRecipes() {
        this.filteredRecipes = this.lastSearchText.isEmpty() ? this.clientRecipes : this.clientRecipes.stream().filter(holder -> {
            ItemStack result = ((CraftingRecipe)holder.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
            String name = result.getHoverName().getString().toLowerCase();
            return name.contains(this.lastSearchText);
        }).toList();
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.searchBox.charTyped(codePoint, modifiers) || super.charTyped(codePoint, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.searchBox.isFocused() && (this.searchBox.keyPressed(keyCode, scanCode, modifiers) || this.searchBox.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.filteredRecipes.isEmpty() && !this.clientRecipes.isEmpty() && this.lastSearchText.isEmpty()) {
            this.filteredRecipes = this.clientRecipes;
        }
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderRecipeIngredients(guiGraphics, mouseX, mouseY);
        this.renderRecipeIcons(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderRecipeIcons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        List<RecipeHolder<CraftingRecipe>> recipes = this.filteredRecipes;
        int xStart = (this.width - this.imageWidth) / 2 + 11;
        int yStart = (this.height - this.imageHeight) / 2 + 17;
        int maxRows = (int)Math.ceil((float)recipes.size() / 8.0f);
        int maxScroll = Math.max(0, maxRows - 3);
        this.scrollOffset = Math.min(this.scrollOffset, maxScroll);
        this.scrollOffset = Math.max(this.scrollOffset, 0);
        this.hoveredRecipeIndex = -1;
        for (int i = 0; i < recipes.size(); ++i) {
            int row = i / 8;
            int col = i % 8;
            if (row < this.scrollOffset || row >= this.scrollOffset + 3) continue;
            RecipeHolder<CraftingRecipe> recipe = recipes.get(i);
            assert (Minecraft.getInstance().level != null);
            ItemStack resultStack = ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).copy();
            int iconX = xStart + col * 17;
            int iconY = yStart + (row - this.scrollOffset) * 17;
            guiGraphics.renderItem(resultStack, iconX, iconY);
            guiGraphics.renderItemDecorations(this.minecraft.font, resultStack, iconX, iconY);
            if (mouseX < iconX || mouseX > iconX + 16 || mouseY < iconY || mouseY > iconY + 16) continue;
            this.hoveredRecipeIndex = i;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(resultStack.getHoverName());
            if (SmartCraftingScreen.hasShiftDown()) {
                tooltip.add(Component.literal((String)"SHIFT to craft as many as possible!").withStyle(ChatFormatting.RED));
            }
            guiGraphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        int guiX = (this.width - this.imageWidth) / 2;
        int guiY = (this.height - this.imageHeight) / 2;
        int totalRows = (int)Math.ceil((double)this.filteredRecipes.size() / 8.0);
        if (maxScroll > 0) {
            float scrollPercent = (float)this.scrollOffset / (float)maxScroll;
            int knobHeight = 15;
            int trackHeight = 54 - knobHeight;
            int knobY = (int)(scrollPercent * (float)trackHeight);
            guiGraphics.blit(SCROLL_SPRITE, guiX + 154, guiY + 15 + knobY, 0.0f, 0.0f, 12, knobHeight, 12, 15);
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar) {
            int scrollbarY = this.topPos + 15;
            int handleHeight = 15;
            int totalRows = (int)Math.ceil((double)this.filteredRecipes.size() / 8.0);
            int maxScroll = Math.max(0, totalRows - 3);
            int relativeY = (int)mouseY - scrollbarY - this.dragOffsetY;
            float percent = Mth.clamp((float)((float)relativeY / (float)(54 - handleHeight)), (float)0.0f, (float)1.0f);
            this.scrollOffset = Mth.clamp((int)Math.round(percent * (float)maxScroll), (int)0, (int)maxScroll);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private void renderRecipeIngredients(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.hoveredRecipeIndex == -1) {
            return;
        }
        if (this.filteredRecipes.isEmpty() || this.hoveredRecipeIndex < 0 || this.hoveredRecipeIndex >= this.filteredRecipes.size()) {
            return;
        }
        RecipeHolder<CraftingRecipe> recipeHolder = this.filteredRecipes.get(this.hoveredRecipeIndex);
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        NonNullList ingredients = recipe.getIngredients();
        int gridSize = 3;
        int iconSize = 18;
        int tooltipX = this.leftPos - 58;
        int tooltipY = this.topPos;
        int recipeWidth = 3;
        int recipeHeight = 3;
        int offsetX = 0;
        int offsetY = 0;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            recipeWidth = shaped.getWidth();
            recipeHeight = shaped.getHeight();
            offsetX = (gridSize - recipeWidth) / 2;
            offsetY = (gridSize - recipeHeight) / 2;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.0f);
        int texWidth = 64;
        int texHeight = 64;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CRAFTING_TOOLTIP_TEXTURE);
        guiGraphics.blit(CRAFTING_TOOLTIP_TEXTURE, tooltipX, tooltipY, 0.0f, 0.0f, 62, 62, 62, 62);
        for (int slotY = 0; slotY < gridSize; ++slotY) {
            for (int slotX = 0; slotX < gridSize; ++slotX) {
                Ingredient ing;
                int ingredientIndex;
                int ingredientX = slotX - offsetX;
                int ingredientY = slotY - offsetY;
                ItemStack stack = ItemStack.EMPTY;
                if (ingredientX >= 0 && ingredientX < recipeWidth && ingredientY >= 0 && ingredientY < recipeHeight && (ingredientIndex = ingredientY * recipeWidth + ingredientX) < ingredients.size() && !(ing = (Ingredient)ingredients.get(ingredientIndex)).isEmpty()) {
                    ItemStack matchedStack = ItemStack.EMPTY;
                    ItemStack[] matchingStacks = ing.getItems();
                    if (matchingStacks.length > 0) {
                        assert (Minecraft.getInstance().player != null);
                        for (ItemStack inventoryStack : Minecraft.getInstance().player.getInventory().items) {
                            if (inventoryStack.isEmpty()) continue;
                            for (ItemStack candidate : matchingStacks) {
                                if (!ItemStack.isSameItem((ItemStack)inventoryStack, (ItemStack)candidate)) continue;
                                matchedStack = inventoryStack.copy();
                                matchedStack.setCount(1);
                                break;
                            }
                            if (matchedStack.isEmpty()) continue;
                            break;
                        }
                        if (matchedStack.isEmpty()) {
                            matchedStack = matchingStacks[0];
                        }
                        stack = matchedStack;
                    }
                }
                int x = tooltipX + slotX * iconSize + 5;
                int y = tooltipY + slotY * iconSize + 5;
                guiGraphics.renderItem(stack, x, y);
                if (stack.isEmpty()) continue;
                guiGraphics.renderItemDecorations(this.minecraft.font, stack, x, y);
            }
        }
        guiGraphics.pose().popPose();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int xStart = (this.width - this.imageWidth) / 2 + 11;
            int yStart = (this.height - this.imageHeight) / 2 + 17;
            for (int i = 0; i < this.filteredRecipes.size(); ++i) {
                int row = i / 8;
                int col = i % 8;
                if (row < this.scrollOffset || row >= this.scrollOffset + 3) continue;
                int iconX = xStart + col * 17;
                int iconY = yStart + (row - this.scrollOffset) * 17;
                if (!(mouseX >= (double)iconX) || !(mouseX <= (double)(iconX + 16)) || !(mouseY >= (double)iconY) || !(mouseY <= (double)(iconY + 16))) continue;
                ResourceLocation recipeId = this.filteredRecipes.get(i).id();
                assert (Minecraft.getInstance().player != null);
                boolean isShiftClick = SmartCraftingScreen.hasShiftDown();
                PacketDistributor.sendToServer((CustomPacketPayload)new SmartCraftingRecipeClickPayload(recipeId, isShiftClick), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        if (button == 1 && this.searchBox.isMouseOver(mouseX, mouseY)) {
            this.searchBox.setValue("");
            this.onSearchTextChanged("");
            return true;
        }
        int scrollbarX = this.leftPos + 154;
        int scrollbarY = this.topPos + 15;
        int handleHeight = 15;
        int maxScroll = Math.max(0, this.filteredRecipes.size() - this.itemsPerPage);
        if (maxScroll > 0) {
            float scrollPercent = (float)this.scrollOffset / (float)maxScroll;
            int handleY = scrollbarY + (int)((float)(54 - handleHeight) * scrollPercent);
            if (MouseUtil.isMouseOver(mouseX, mouseY, scrollbarX, handleY, 12, handleHeight)) {
                this.isDraggingScrollbar = true;
                this.dragOffsetY = (int)mouseY - handleY;
                return true;
            }
            this.isDraggingScrollbar = false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int maxRows = (int)Math.ceil((float)this.filteredRecipes.size() / 8.0f);
        int maxScroll = Math.max(0, maxRows - 3);
        if (deltaY < 0.0 && this.scrollOffset < maxScroll) {
            ++this.scrollOffset;
        } else if (deltaY > 0.0 && this.scrollOffset > 0) {
            --this.scrollOffset;
        }
        return true;
    }
}

