/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.custom;

import com.benbenlaw.opolisutilities.block.entity.custom.RedstoneClockBlockEntity;
import com.benbenlaw.opolisutilities.networking.payload.DecreaseTickButtonPayload;
import com.benbenlaw.opolisutilities.networking.payload.IncreaseTickButtonPayload;
import com.benbenlaw.opolisutilities.screen.custom.RedstoneClockMenu;
import com.benbenlaw.opolisutilities.screen.utils.ModButtons;
import com.benbenlaw.opolisutilities.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneClockScreen
extends AbstractContainerScreen<RedstoneClockMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/redstone_clock_gui.png");

    public RedstoneClockScreen(RedstoneClockMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.addMenuButtons();
    }

    protected void containerTick() {
        this.clearWidgets();
        this.addMenuButtons();
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((RedstoneClockMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 84, y + 30, 176, 0, 8, ((RedstoneClockMenu)this.menu).getScaledProgress());
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderTickRate(guiGraphics, mouseX, mouseY, this.leftPos + 5, this.height / 2 - 66);
    }

    @Nullable
    private void renderTickRate(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, 0, 0, 20, 54)) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.opolisutilities.shift"), this.leftPos + 95, this.topPos + 45, 0x3F3F3F, false);
            int ticks = 0;
            BlockEntity blockEntity = ((RedstoneClockMenu)this.menu).level.getBlockEntity(((RedstoneClockMenu)this.menu).blockPos);
            if (blockEntity instanceof RedstoneClockBlockEntity) {
                RedstoneClockBlockEntity redstoneClockBlockEntity = (RedstoneClockBlockEntity)blockEntity;
                ticks = redstoneClockBlockEntity.maxProgress;
            }
            guiGraphics.drawString(this.font, ticks + " ticks", this.leftPos + 95, this.topPos + 35, 0x3F3F3F, false);
        }
    }

    private void addMenuButtons() {
        boolean isShiftDown = RedstoneClockScreen.hasShiftDown();
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 32, 20, 18, ModButtons.DECREASE_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new DecreaseTickButtonPayload(((RedstoneClockMenu)this.menu).blockEntity.getBlockPos(), isShiftDown), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 66, 20, 18, ModButtons.INCREASE_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new IncreaseTickButtonPayload(((RedstoneClockMenu)this.menu).blockEntity.getBlockPos(), isShiftDown), (CustomPacketPayload[])new CustomPacketPayload[0])));
    }
}

