/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.custom;

import com.benbenlaw.opolisutilities.networking.payload.ClearTankPayload;
import com.benbenlaw.opolisutilities.screen.custom.FluidGeneratorMenu;
import com.benbenlaw.opolisutilities.screen.utils.FluidStackWidget;
import com.benbenlaw.opolisutilities.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class FluidGeneratorScreen
extends AbstractContainerScreen<FluidGeneratorMenu> {
    Level level;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/fluid_generator_gui.png");

    public FluidGeneratorScreen(FluidGeneratorMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.level = pMenu.level;
    }

    protected void init() {
        super.init();
        this.addFluidWidgets();
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((FluidGeneratorMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 84, y + 35, 176, 0, 8, ((FluidGeneratorMenu)this.menu).getScaledProgress());
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderTickRate(guiGraphics, mouseX, mouseY, x, y);
        this.renderWarning(guiGraphics, mouseX, mouseY);
    }

    private void renderTickRate(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, 116, 16, 16, 16)) {
            guiGraphics.drawString(this.font, ((FluidGeneratorMenu)this.menu).blockEntity.maxProgress + " ticks", this.leftPos + 120, this.topPos + 68, 0x3F3F3F, false);
        }
    }

    private void addFluidWidgets() {
        this.addRenderableOnly((Renderable)new FluidStackWidget((Screen)this, ((FluidGeneratorMenu)this.getMenu()).blockEntity.FLUID_TANK, this.leftPos + 14, this.topPos + 15, 14, 56));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = super.mouseClicked(mouseX, mouseY, mouseButton);
        int tankX = this.leftPos + 14;
        int tankY = this.topPos + 15;
        int tankWidth = 14;
        int tankHeight = 56;
        if (MouseUtil.isMouseOver(mouseX, mouseY, tankX, tankY, tankWidth, tankHeight)) {
            int tank = ((FluidGeneratorMenu)this.menu).blockEntity.FLUID_TANK.getTanks();
            boolean hasShiftDown = FluidGeneratorScreen.hasShiftDown();
            PacketDistributor.sendToServer((CustomPacketPayload)new ClearTankPayload(((FluidGeneratorMenu)this.menu).blockEntity.getBlockPos(), hasShiftDown, tank), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return handled;
    }

    private void renderWarning(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int tankX = this.leftPos + 14;
        int tankY = this.topPos + 15;
        int tankWidth = 14;
        int tankHeight = 56;
        if (MouseUtil.isMouseOver(mouseX, mouseY, tankX, tankY, tankWidth, tankHeight) && FluidGeneratorScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.opolisutilities.warning").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
    }
}

