/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.custom;

import com.benbenlaw.opolisutilities.block.custom.CrafterBlock;
import com.benbenlaw.opolisutilities.block.entity.custom.CrafterBlockEntity;
import com.benbenlaw.opolisutilities.networking.payload.DecreaseTickButtonPayload;
import com.benbenlaw.opolisutilities.networking.payload.IncreaseTickButtonPayload;
import com.benbenlaw.opolisutilities.networking.payload.OnOffButtonPayload;
import com.benbenlaw.opolisutilities.networking.payload.SaveRecipePayload;
import com.benbenlaw.opolisutilities.screen.custom.CrafterMenu;
import com.benbenlaw.opolisutilities.screen.utils.ModButtons;
import com.benbenlaw.opolisutilities.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrafterScreen
extends AbstractContainerScreen<CrafterMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/crafter_gui.png");

    public CrafterScreen(CrafterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.addMenuButtons();
    }

    protected void containerTick() {
        this.clearWidgets();
        this.addMenuButtons();
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((CrafterMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 89, y + 33, 176, 30, ((CrafterMenu)this.menu).getScaledProgress(), 16);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderTickRate(guiGraphics, mouseX, mouseY, x, y);
    }

    @Nullable
    private void renderTickRate(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        CrafterBlockEntity crafterBlockEntity;
        BlockEntity blockEntity;
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, 4, 13, 20, 54)) {
            int ticks = 0;
            blockEntity = ((CrafterMenu)this.menu).level.getBlockEntity(((CrafterMenu)this.menu).blockPos);
            if (blockEntity instanceof CrafterBlockEntity) {
                crafterBlockEntity = (CrafterBlockEntity)blockEntity;
                ticks = crafterBlockEntity.maxProgress;
            }
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.opolisutilities.shift"), this.leftPos + 87, this.topPos + 60, 0x3F3F3F, false);
            guiGraphics.drawString(this.font, ticks + " ticks", this.leftPos + 87, this.topPos + 70, 0x3F3F3F, false);
        }
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, 148, 30, 20, 18)) {
            ItemStack itemStack = ItemStack.EMPTY;
            blockEntity = ((CrafterMenu)this.menu).level.getBlockEntity(((CrafterMenu)this.menu).blockPos);
            if (blockEntity instanceof CrafterBlockEntity) {
                Optional recipe;
                crafterBlockEntity = (CrafterBlockEntity)blockEntity;
                if (crafterBlockEntity.recipeID != null && (recipe = ((CrafterMenu)this.menu).level.getRecipeManager().byKey(ResourceLocation.parse((String)String.valueOf(crafterBlockEntity.recipeID)))).isPresent()) {
                    CraftingRecipe r = (CraftingRecipe)((RecipeHolder)recipe.get()).value();
                    itemStack = r.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).copy();
                }
                Object additionalInfo = itemStack.getCount() == 1 ? itemStack.getDisplayName().getString().replace("[", "").replace("]", "") : itemStack.getCount() + "x " + itemStack.getDisplayName().getString().replace("[", "").replace("]", "");
                guiGraphics.drawString(this.font, "Current Recipe:", this.leftPos + 87, this.topPos + 60, 0x3F3F3F, false);
                guiGraphics.drawString(this.font, (String)additionalInfo, this.leftPos + 87, this.topPos + 70, 0x3F3F3F, false);
            }
        }
    }

    private void addMenuButtons() {
        if (!((Boolean)((CrafterMenu)this.menu).blockEntity.getBlockState().getValue((Property)CrafterBlock.POWERED)).booleanValue()) {
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 49, 20, 18, ModButtons.OFF_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((CrafterMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        } else {
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 49, 20, 18, ModButtons.ON_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((CrafterMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
        boolean isShiftDown = CrafterScreen.hasShiftDown();
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 32, 20, 18, ModButtons.DECREASE_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new DecreaseTickButtonPayload(((CrafterMenu)this.menu).blockEntity.getBlockPos(), isShiftDown), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 66, 20, 18, ModButtons.INCREASE_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new IncreaseTickButtonPayload(((CrafterMenu)this.menu).blockEntity.getBlockPos(), isShiftDown), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 148, this.height / 2 - 49, 20, 18, ModButtons.SAVED_RECIPE_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new SaveRecipePayload(((CrafterMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
    }
}

