/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.custom;

import com.benbenlaw.opolisutilities.block.custom.BlockBreakerBlock;
import com.benbenlaw.opolisutilities.networking.payload.OnOffButtonPayload;
import com.benbenlaw.opolisutilities.screen.custom.BlockBreakerMenu;
import com.benbenlaw.opolisutilities.screen.utils.ModButtons;
import com.benbenlaw.opolisutilities.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class BlockBreakerScreen
extends AbstractContainerScreen<BlockBreakerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/block_breaker_gui.png");

    public BlockBreakerScreen(BlockBreakerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.addMenuButtons();
    }

    protected void containerTick() {
        this.clearWidgets();
        this.addMenuButtons();
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((BlockBreakerMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 84, y + 45, 176, 0, 8, ((BlockBreakerMenu)this.menu).getScaledProgress());
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderTickRate(guiGraphics);
        this.renderToolSlotTooltip(guiGraphics, mouseX, mouseY, x, y);
        this.renderWhitelistTooltip(guiGraphics, mouseX, mouseY, x, y);
        this.renderBlacklistTooltip(guiGraphics, mouseX, mouseY, x, y);
    }

    private void renderToolSlotTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, 40, 26, 16, 16) && ((BlockBreakerMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.gui.tool_slot"), mouseX, mouseY);
        }
    }

    private void renderWhitelistTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, 80, 26, 16, 16) && ((BlockBreakerMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.gui.whitelist_slot"), mouseX, mouseY);
        }
    }

    private void renderBlacklistTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, 120, 26, 16, 16) && ((BlockBreakerMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.gui.blacklist_slot"), mouseX, mouseY);
        }
    }

    private void addMenuButtons() {
        if (((BlockBreakerMenu)this.menu).blockEntity != null) {
            boolean isPowered = (Boolean)((BlockBreakerMenu)this.menu).blockEntity.getBlockState().getValue((Property)BlockBreakerBlock.POWERED);
            if (!isPowered) {
                this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 49, 20, 18, ModButtons.OFF_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((BlockBreakerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
            } else {
                this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 49, 20, 18, ModButtons.ON_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((BlockBreakerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }
    }

    private void renderTickRate(GuiGraphics guiGraphics) {
        if (((BlockBreakerMenu)this.menu).blockEntity.progress != 0) {
            guiGraphics.drawString(this.font, "Breaking Time", this.leftPos + 100, this.topPos + 50, 0x3F3F3F, false);
            guiGraphics.drawString(this.font, ((BlockBreakerMenu)this.menu).blockEntity.progress + "/" + ((BlockBreakerMenu)this.menu).blockEntity.maxProgress, this.leftPos + 100, this.topPos + 60, 0x3F3F3F, false);
        }
    }
}

