/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.item.custom;

import com.benbenlaw.opolisutilities.config.StartupItemConfigFile;
import com.benbenlaw.opolisutilities.item.ModDataComponents;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.NotNull;

public class HomeStoneItem
extends Item {
    public ResourceKey<Level> dimension = null;

    public HomeStoneItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!level.isClientSide() && player.isCrouching() && hand == InteractionHand.OFF_HAND) {
            itemstack.set((DataComponentType)ModDataComponents.INT_X.get(), (Object)player.getOnPos().getX());
            itemstack.set((DataComponentType)ModDataComponents.INT_Y.get(), (Object)player.getOnPos().getY());
            itemstack.set((DataComponentType)ModDataComponents.INT_Z.get(), (Object)player.getOnPos().getZ());
            ResourceLocation dim = level.dimension().location();
            itemstack.set((DataComponentType)ModDataComponents.DIMENSION.get(), (Object)(dim.getNamespace() + ":" + dim.getPath()));
            player.playNotifySound(SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.sendSystemMessage((Component)Component.translatable((String)"tooltips.home_stone.location_set").withStyle(ChatFormatting.GREEN));
        }
        if (!level.isClientSide() && hand == InteractionHand.MAIN_HAND && itemstack.get((DataComponentType)ModDataComponents.INT_X.get()) == null) {
            player.playNotifySound(SoundEvents.SHIELD_BLOCK, SoundSource.AMBIENT, 0.2f, 1.0f);
            player.sendSystemMessage((Component)Component.translatable((String)"tooltips.home_stone.no_location").withStyle(ChatFormatting.RED));
        } else if (!level.isClientSide() && hand == InteractionHand.MAIN_HAND) {
            this.dimension = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dimension")), (ResourceLocation)ResourceLocation.parse((String)Objects.requireNonNull((String)itemstack.get((DataComponentType)ModDataComponents.DIMENSION.get()))));
            MinecraftServer minecraftserver = player.getServer();
            assert (minecraftserver != null);
            ServerLevel destinationWorld = minecraftserver.getLevel(this.dimension);
            assert (destinationWorld != null);
            player.changeDimension(new DimensionTransition(destinationWorld, (Entity)player, DimensionTransition.DO_NOTHING));
            player.teleportTo((double)((Integer)itemstack.get((DataComponentType)ModDataComponents.INT_X.get())).intValue() + 0.5, (double)((Integer)itemstack.get((DataComponentType)ModDataComponents.INT_Y.get()) + 1), (double)((Integer)itemstack.get((DataComponentType)ModDataComponents.INT_Z.get())).intValue() + 0.5);
            player.getCooldowns().addCooldown((Item)this, ((Integer)StartupItemConfigFile.homeStoneCooldown.get()).intValue());
            player.playNotifySound(SoundEvents.PORTAL_TRAVEL, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.sendSystemMessage((Component)Component.translatable((String)"tooltips.home_stone.going_saved_location").withStyle(ChatFormatting.GREEN));
            if (((Boolean)StartupItemConfigFile.homeStoneTakesDamage.get()).equals(true)) {
                player.getItemBySlot(EquipmentSlot.MAINHAND).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltips.super_home_stone.shift.held").withStyle(ChatFormatting.GREEN));
        } else {
            components.add((Component)Component.translatable((String)"tooltips.home_stone.hover.shift").withStyle(ChatFormatting.BLUE));
        }
        if (Screen.hasAltDown()) {
            Integer x = (Integer)stack.get((DataComponentType)ModDataComponents.INT_X.get());
            Integer y = (Integer)stack.get((DataComponentType)ModDataComponents.INT_Y.get());
            Integer z = (Integer)stack.get((DataComponentType)ModDataComponents.INT_Z.get());
            String dimension = (String)stack.get((DataComponentType)ModDataComponents.DIMENSION.get());
            if (x != null && y != null && z != null && dimension != null) {
                components.add((Component)Component.literal((String)("X: " + String.valueOf(stack.get(ModDataComponents.INT_X)))).withStyle(ChatFormatting.GREEN));
                components.add((Component)Component.literal((String)("Y: " + String.valueOf(stack.get(ModDataComponents.INT_Y)))).withStyle(ChatFormatting.GREEN));
                components.add((Component)Component.literal((String)("Z: " + String.valueOf(stack.get(ModDataComponents.INT_Z)))).withStyle(ChatFormatting.GREEN));
                components.add((Component)Component.literal((String)("Dimension: " + (String)stack.get(ModDataComponents.DIMENSION))).withStyle(ChatFormatting.GREEN));
            } else {
                components.add((Component)Component.translatable((String)"tooltips.home_stone.no_location_set").withStyle(ChatFormatting.RED));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltips.home_stone.hover.alt").withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(stack, tooltipContext, components, flag);
    }
}

