/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.item.custom;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class FloatingBlockItem
extends Item {
    public FloatingBlockItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && hand == InteractionHand.MAIN_HAND) {
            int zPos;
            int yPos;
            int xPos = (int)(player.getX() + 3.0 * player.getLookAngle().x);
            BlockPos blockPos = new BlockPos(xPos, yPos = (int)(1.5 + player.getY() + 3.0 * player.getLookAngle().y), zPos = (int)(player.getZ() + 3.0 * player.getLookAngle().z));
            if (level.getBlockState(blockPos).is(Blocks.WATER)) {
                level.setBlockAndUpdate(blockPos, ((Block)ModBlocks.FLOATING_BLOCK.get()).defaultBlockState());
                if (!player.isCreative()) {
                    player.getItemInHand(hand).shrink(1);
                }
            }
            if (level.getBlockState(blockPos).is(Blocks.AIR)) {
                level.setBlockAndUpdate(blockPos, ((Block)ModBlocks.FLOATING_BLOCK.get()).defaultBlockState());
                if (!player.isCreative()) {
                    player.getItemInHand(hand).shrink(1);
                }
            }
        }
        return super.use(level, player, hand);
    }
}

