/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.item.custom;

import com.benbenlaw.opolisutilities.item.ModDataComponents;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;

public class DeathStoneItem
extends Item {
    public ResourceKey<Level> dimension = null;

    public DeathStoneItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        DataComponentMap dataComponentMap = itemstack.getComponents();
        if (!level.isClientSide() && hand == InteractionHand.MAIN_HAND && Objects.requireNonNull((String)itemstack.get(ModDataComponents.DIMENSION)).isEmpty()) {
            player.playNotifySound(SoundEvents.SHIELD_BLOCK, SoundSource.AMBIENT, 0.2f, 1.0f);
            player.sendSystemMessage((Component)Component.translatable((String)"tooltips.death_stone.how").withStyle(ChatFormatting.RED));
        } else if (!level.isClientSide() && hand == InteractionHand.MAIN_HAND) {
            this.dimension = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dimension")), (ResourceLocation)ResourceLocation.parse((String)Objects.requireNonNull((String)dataComponentMap.get((DataComponentType)ModDataComponents.DIMENSION.get()))));
            MinecraftServer minecraftserver = player.getServer();
            assert (minecraftserver != null);
            ServerLevel destinationWorld = minecraftserver.getLevel(this.dimension);
            assert (destinationWorld != null);
            player.changeDimension(new DimensionTransition(destinationWorld, (Entity)player, DimensionTransition.DO_NOTHING));
            player.teleportTo((double)((Integer)dataComponentMap.get((DataComponentType)ModDataComponents.INT_X.get())).intValue() + 0.5, (double)((Integer)dataComponentMap.get((DataComponentType)ModDataComponents.INT_Y.get()) + 1), (double)((Integer)dataComponentMap.get((DataComponentType)ModDataComponents.INT_Z.get())).intValue() + 0.5);
            player.getItemInHand(hand).shrink(1);
            player.playNotifySound(SoundEvents.PORTAL_TRAVEL, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.sendSystemMessage((Component)Component.translatable((String)"tooltips.home_stone.going_saved_location").withStyle(ChatFormatting.GREEN));
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltips.death_stone.shift.held").withStyle(ChatFormatting.GREEN));
        } else {
            components.add((Component)Component.translatable((String)"tooltips.home_stone.hover.shift").withStyle(ChatFormatting.BLUE));
        }
        if (Screen.hasAltDown()) {
            components.add((Component)Component.literal((String)("X: " + String.valueOf(stack.get(ModDataComponents.INT_X)))).withStyle(ChatFormatting.GREEN));
            components.add((Component)Component.literal((String)("Y: " + String.valueOf(stack.get(ModDataComponents.INT_Y)))).withStyle(ChatFormatting.GREEN));
            components.add((Component)Component.literal((String)("Z: " + String.valueOf(stack.get(ModDataComponents.INT_Z)))).withStyle(ChatFormatting.GREEN));
            components.add((Component)Component.literal((String)("Dimension: " + (String)stack.get(ModDataComponents.DIMENSION))).withStyle(ChatFormatting.GREEN));
        } else {
            components.add((Component)Component.translatable((String)"tooltips.home_stone.hover.alt").withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(stack, tooltipContext, components, flag);
    }
}

