/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.recipe.SummoningBlockRecipe;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummoningRecipeCategory
implements IRecipeCategory<SummoningBlockRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"summoning_block");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/jei_summoning_block.png");
    static final RecipeType<SummoningBlockRecipe> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"summoning_block", SummoningBlockRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    @Nullable
    public ResourceLocation getRegistryName(SummoningBlockRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)SummoningBlockRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((SummoningBlockRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public SummoningRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 103, 19);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SUMMONING_BLOCK.get()));
    }

    public RecipeType<SummoningBlockRecipe> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.SUMMOMING_BLOCK;
    }

    public Component getTitle() {
        return Component.literal((String)"Summoning");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SummoningBlockRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 2).addIngredients(recipe.input().ingredient());
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 2).addIngredients(recipe.catalyst());
        @Nullable EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)recipe.mob()));
        ItemStack spawnEgg = Objects.requireNonNull(SpawnEggItem.byId((EntityType)entity)).getDefaultInstance();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 84, 2).addItemStack(new ItemStack((ItemLike)spawnEgg.getItem()));
    }
}

