/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.recipe.FluidGeneratorRecipe;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidGeneratorRecipeCategory
implements IRecipeCategory<FluidGeneratorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"fluid_generator");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/jei_dynamic.png");
    static final RecipeType<FluidGeneratorRecipe> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"fluid_generator", FluidGeneratorRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private int tabs_used = 0;
    private final Map<Point, FluidGeneratorRecipe> slotRecipes = new HashMap<Point, FluidGeneratorRecipe>();
    private int backgroundWidth;

    @Nullable
    public ResourceLocation getRegistryName(FluidGeneratorRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)FluidGeneratorRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((FluidGeneratorRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public FluidGeneratorRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 175, 57);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FLUID_GENERATOR.get()));
    }

    @NotNull
    public RecipeType<FluidGeneratorRecipe> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.FLUID_GENERATOR;
    }

    public boolean isHandled(FluidGeneratorRecipe recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Fluid Generator");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidGeneratorRecipe recipe, @NotNull IFocusGroup focusGroup) {
        ++this.tabs_used;
        List recipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)FluidGeneratorRecipe.Type.INSTANCE);
        int yOffset = 20;
        int numRows = (int)Math.ceil((double)recipes.size() / 9.0);
        int numCols = 9;
        this.backgroundWidth = 4 + numCols * 19;
        int backgroundHeight = 2 + numRows * 19 + yOffset;
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, this.backgroundWidth, backgroundHeight);
        this.slotRecipes.clear();
        for (int i = 0; i < recipes.size(); ++i) {
            int slotX = 4 + i % 9 * 19;
            int slotY = yOffset + 2 + i / 9 * 19;
            int finalI = i;
            builder.addSlot(RecipeIngredientRole.OUTPUT, slotX, slotY).addFluidStack(((FluidGeneratorRecipe)((RecipeHolder)recipes.get(i)).value()).input().getFluid(), 1000L);
            this.slotRecipes.put(new Point(slotX, slotY), (FluidGeneratorRecipe)((RecipeHolder)recipes.get(i)).value());
        }
    }

    public void draw(FluidGeneratorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        String infoText = null;
        for (Map.Entry<Point, FluidGeneratorRecipe> entry : this.slotRecipes.entrySet()) {
            Point position = entry.getKey();
            FluidGeneratorRecipe hoveredRecipe = entry.getValue();
            int slotX = position.x;
            int slotY = position.y;
            int slotWidth = 18;
            int slotHeight = 18;
            if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + slotWidth)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + slotHeight))) continue;
            int amount = hoveredRecipe.input().getAmount();
            infoText = "Fluid Generated: " + amount + "mB";
            break;
        }
        if (infoText != null) {
            int screenWidth = this.backgroundWidth;
            int textWidth = Minecraft.getInstance().font.width(infoText);
            int textX = (screenWidth - textWidth) / 2;
            int textY = 4;
            guiGraphics.drawString(Minecraft.getInstance().font, infoText, textX, textY, -1, true);
        }
    }
}

