/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.custom.CrafterBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.handler.InputOutputItemHandler;
import com.benbenlaw.opolisutilities.screen.custom.CrafterMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrafterBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            CrafterBlockEntity.this.setChanged();
            CrafterBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot <= 8) {
                return 2;
            }
            return super.getStackLimit(slot, stack);
        }
    };
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 220;
    private int recipeChecker = 0;
    public ItemStack craftingItem;
    public Map<Integer, ItemStack> ingredientMap = new HashMap<Integer, ItemStack>();
    public List<ItemStack> remainingItems;
    public ResourceLocation recipeID = ResourceLocation.parse((String)"minecraft:air");
    private NonNullList<Ingredient> craftingIngredients;
    private final IItemHandler crafterItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> {
        ItemStack requiredStack;
        if (i >= 0 && i <= 8 && (requiredStack = this.ingredientMap.get(i)) != null && !requiredStack.isEmpty()) {
            return ItemStack.isSameItem((ItemStack)stack, (ItemStack)requiredStack) && stack.getCount() <= requiredStack.getCount();
        }
        return false;
    }, i -> i == 9);

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.crafterItemHandler;
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public CrafterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CRAFTER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> CrafterBlockEntity.this.progress;
                    case 1 -> CrafterBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        CrafterBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        CrafterBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        this.remainingItems = new ArrayList<ItemStack>();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.opolisutilities.crafter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new CrafterMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.getCraftingIngredients();
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        compoundTag.putInt("recipeChecker", this.recipeChecker);
        compoundTag.putString("recipeID", this.recipeID.toString());
        ListTag ingredientList = new ListTag();
        for (Map.Entry<Integer, ItemStack> entry : this.ingredientMap.entrySet()) {
            CompoundTag ingredientTag = new CompoundTag();
            ingredientTag.putInt("slot", entry.getKey().intValue());
            ingredientTag.put("item", entry.getValue().save(provider));
            ingredientList.add((Object)ingredientTag);
        }
        compoundTag.put("ingredientMap", (Tag)ingredientList);
        ListTag remainingItemsTag = new ListTag();
        for (ItemStack stack : this.remainingItems) {
            remainingItemsTag.add((Object)stack.save(provider));
        }
        compoundTag.put("remainingItems", (Tag)remainingItemsTag);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.recipeChecker = compoundTag.getInt("recipeChecker");
        this.recipeID = ResourceLocation.parse((String)compoundTag.getString("recipeID"));
        ListTag ingredientList = compoundTag.getList("ingredientMap", 10);
        for (Tag tag : ingredientList) {
            CompoundTag ingredientTag = (CompoundTag)tag;
            int slot = ingredientTag.getInt("slot");
            ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)ingredientTag.getCompound("item"));
            this.ingredientMap.put(slot, item);
        }
        ListTag remainingItemsTag = compoundTag.getList("remainingItems", 10);
        for (Tag tag : remainingItemsTag) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)tag));
            this.remainingItems.add(stack);
        }
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    private void resetProgress() {
        this.progress = 0;
        this.setChanged();
    }

    public void tick() {
        ++this.recipeChecker;
        Level level = this.level;
        assert (level != null);
        BlockPos blockPos = this.worldPosition;
        BlockState blockState = level.getBlockState(blockPos);
        if (!level.isClientSide()) {
            this.sync();
            if (!this.remainingItems.isEmpty() && this.itemHandler.getStackInSlot(9).isEmpty()) {
                this.itemHandler.setStackInSlot(9, this.remainingItems.get(0));
                this.remainingItems.remove(0);
            }
            if (((Boolean)blockState.getValue((Property)CrafterBlock.POWERED)).booleanValue()) {
                if (!this.craftingItem.isEmpty() && this.canCraft() && this.hasMaterial()) {
                    ++this.progress;
                    if (this.progress >= this.maxProgress) {
                        this.craft();
                        this.resetProgress();
                        this.setChanged();
                    }
                } else {
                    this.resetProgress();
                    this.setChanged();
                }
            } else {
                this.resetProgress();
                this.setChanged();
            }
        }
    }

    public boolean canCraft() {
        ItemStack stack = this.itemHandler.getStackInSlot(9);
        int count = stack.getCount();
        boolean same = ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.craftingItem) && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.craftingItem);
        boolean fits = count + this.craftingItem.getCount() <= this.craftingItem.getMaxStackSize();
        return stack.isEmpty() || same && fits;
    }

    public void updateRecipe() {
        CraftingContainer container = new CraftingContainer(){

            public int getWidth() {
                return 3;
            }

            public int getHeight() {
                return 3;
            }

            @NotNull
            public List<ItemStack> getItems() {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int i = 0; i < 9; ++i) {
                    list.add(CrafterBlockEntity.this.itemHandler.getStackInSlot(i));
                }
                return list;
            }

            public int getContainerSize() {
                return this.getWidth() * this.getHeight();
            }

            public boolean isEmpty() {
                return false;
            }

            @NotNull
            public ItemStack getItem(int slot) {
                return this.getItems().get(slot);
            }

            @NotNull
            public ItemStack removeItem(int slot, int amount) {
                return ItemStack.EMPTY;
            }

            @NotNull
            public ItemStack removeItemNoUpdate(int slot) {
                return ItemStack.EMPTY;
            }

            public void setItem(int slot, @NotNull ItemStack stack) {
            }

            public void setChanged() {
            }

            public boolean stillValid(@NotNull Player player) {
                return true;
            }

            public void clearContent() {
            }

            public void fillStackedContents(@NotNull StackedContents helper) {
            }
        };
        for (int i = 0; i < 9; ++i) {
            container.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)container.asCraftInput(), this.level);
        if (recipe.isPresent()) {
            CraftingRecipe r = (CraftingRecipe)((RecipeHolder)recipe.get()).value();
            this.craftingItem = r.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).copy();
            this.craftingIngredients = r.getIngredients();
            this.recipeID = ((RecipeHolder)recipe.get()).id();
            System.out.println("Recipe found: " + String.valueOf(this.recipeID));
            this.ingredientMap.clear();
            for (Ingredient ingredient : this.craftingIngredients) {
                ItemStack[] matches = ingredient.getItems();
                if (matches.length <= 0) continue;
                block2: for (int slot = 0; slot < container.getContainerSize(); ++slot) {
                    ItemStack slotItem = container.getItem(slot);
                    for (ItemStack match : matches) {
                        if (!ItemStack.isSameItem((ItemStack)slotItem, (ItemStack)match)) continue;
                        this.ingredientMap.put(slot, new ItemStack(slotItem.getItemHolder(), 1));
                        continue block2;
                    }
                }
            }
            System.out.println("Ingredient map: " + String.valueOf(this.ingredientMap));
        } else {
            this.craftingItem = ItemStack.EMPTY.copy();
            System.out.println("No recipe found.");
        }
    }

    public void getCraftingIngredients() {
        assert (this.level != null);
        Optional recipe = this.level.getRecipeManager().byKey(this.recipeID);
        if (recipe.isPresent()) {
            CraftingRecipe r = (CraftingRecipe)((RecipeHolder)recipe.get()).value();
            this.craftingItem = r.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).copy();
            this.craftingIngredients = r.getIngredients();
            this.recipeID = ((RecipeHolder)recipe.get()).id();
        } else {
            this.craftingItem = ItemStack.EMPTY.copy();
        }
    }

    public void craft() {
        this.extractIngredients();
        this.itemHandler.insertItem(9, this.craftingItem.copy(), false);
    }

    public void extractIngredients() {
        if (this.ingredientMap != null && !this.ingredientMap.isEmpty()) {
            ArrayList remainders = new ArrayList();
            for (Map.Entry<Integer, ItemStack> entry : this.ingredientMap.entrySet()) {
                ItemStack remainder;
                int extractCount;
                ItemStack extractedStack;
                ItemStack stackInSlot;
                int slot = entry.getKey();
                ItemStack requiredStack = entry.getValue();
                if (requiredStack.isEmpty() || (stackInSlot = this.itemHandler.getStackInSlot(slot)).isEmpty() || stackInSlot.getCount() < requiredStack.getCount() || (extractedStack = this.itemHandler.extractItem(slot, extractCount = requiredStack.getCount(), false)).isEmpty() || (remainder = extractedStack.getCraftingRemainingItem()).isEmpty()) continue;
                this.remainingItems.add(remainder);
            }
        }
    }

    public boolean hasMaterial() {
        return this.hasIngredientsForRecipe();
    }

    private boolean hasIngredientsForRecipe() {
        if (this.ingredientMap == null || this.ingredientMap.isEmpty()) {
            return false;
        }
        for (Map.Entry<Integer, ItemStack> entry : this.ingredientMap.entrySet()) {
            int slot = entry.getKey();
            ItemStack ingredient = entry.getValue();
            ItemStack slotStack = this.itemHandler.getStackInSlot(slot);
            if (!slotStack.isEmpty() && ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)ingredient) && slotStack.getCount() >= ingredient.getCount()) continue;
            return false;
        }
        return true;
    }

    private HashMap<Item, Integer> countIngredients(NonNullList<Ingredient> ingredients) {
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        for (Ingredient ingredient : ingredients) {
            for (ItemStack stack : ingredient.getItems()) {
                map.put(stack.getItem(), map.getOrDefault(stack.getItem(), 0) + stack.getCount());
            }
        }
        return map;
    }
}

