/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.client;

import com.benbenlaw.opolisutilities.block.entity.custom.ClocheBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;

@Deprecated(forRemoval=true, since="4.11.6")
public class ClocheBlockEntityRenderer
implements BlockEntityRenderer<ClocheBlockEntity> {
    public ClocheBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ClocheBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
        ItemStack soilStack = pBlockEntity.getSoilBlock();
        ItemStack seedStack = pBlockEntity.getSeed();
        Item item = soilStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState soilAsBlock = blockItem.getBlock().defaultBlockState();
            pPoseStack.pushPose();
            pPoseStack.scale(0.9f, 0.2f, 0.9f);
            pPoseStack.translate(0.05f, 0.1f, 0.05f);
            blockRenderDispatcher.renderSingleBlock(soilAsBlock, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, ModelData.EMPTY, RenderType.cutout());
            pPoseStack.popPose();
        }
        int progress = pBlockEntity.progress;
        int maxProgress = pBlockEntity.maxProgress;
        Item item2 = seedStack.getItem();
        if (item2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            BlockState seedAsBlock = blockItem.getBlock().defaultBlockState();
            Block block = seedAsBlock.getBlock();
            if (block instanceof CropBlock) {
                CropBlock ageCropBlock = (CropBlock)block;
                int maxAge = ageCropBlock.getMaxAge();
                int age = Math.round((float)progress / (float)maxProgress * (float)maxAge);
                IntegerProperty ageProperty = null;
                for (Property property : ageCropBlock.getStateDefinition().getProperties()) {
                    IntegerProperty integerProperty;
                    if (!(property instanceof IntegerProperty) || !(integerProperty = (IntegerProperty)property).getPossibleValues().contains(age)) continue;
                    ageProperty = integerProperty;
                    break;
                }
                if (ageProperty instanceof IntegerProperty) {
                    IntegerProperty integerProperty = ageProperty;
                    BlockState seedAsBlockCrop = (BlockState)seedAsBlock.setValue((Property)integerProperty, (Comparable)Integer.valueOf(age));
                    pPoseStack.pushPose();
                    pPoseStack.scale(0.8f, 0.8f, 0.8f);
                    pPoseStack.translate(0.1f, 0.25f, 0.1f);
                    blockRenderDispatcher.renderSingleBlock(seedAsBlockCrop, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, ModelData.EMPTY, RenderType.cutout());
                    pPoseStack.popPose();
                }
            } else if (seedAsBlock.getBlock() instanceof StemBlock) {
                int maxAge = 7;
                int age = Math.round((float)progress / (float)maxProgress * (float)maxAge);
                age = Math.min(age, maxAge);
                BlockState seedAsBlockCrop = (BlockState)seedAsBlock.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(age));
                pPoseStack.pushPose();
                pPoseStack.scale(0.8f, 0.8f, 0.8f);
                pPoseStack.translate(0.1f, 0.25f, 0.1f);
                blockRenderDispatcher.renderSingleBlock(seedAsBlockCrop, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, ModelData.EMPTY, RenderType.cutout());
                pPoseStack.popPose();
            } else {
                pPoseStack.pushPose();
                float growthProgress = (float)progress / (float)maxProgress;
                float minScale = 0.3f;
                float maxScale = 0.6f;
                float scale = minScale + growthProgress * (maxScale - minScale);
                pPoseStack.translate(0.5f, 0.5f, 0.5f);
                float initialLowerOffset = -0.3f;
                float verticalOffset = (scale - minScale) / 2.0f;
                pPoseStack.scale(scale, scale, scale);
                pPoseStack.translate(0.0f, initialLowerOffset + verticalOffset, 0.0f);
                pPoseStack.translate(-0.5f, -0.5f, -0.5f);
                blockRenderDispatcher.renderSingleBlock(seedAsBlock, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, ModelData.EMPTY, RenderType.cutout());
                pPoseStack.popPose();
            }
        }
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

