/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.custom;

import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.FluidGeneratorBlockEntity;
import com.benbenlaw.opolisutilities.item.ModDataComponents;
import com.benbenlaw.opolisutilities.screen.custom.FluidGeneratorMenu;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidGeneratorBlock
extends BaseEntityBlock {
    public static final MapCodec<FluidGeneratorBlock> CODEC = FluidGeneratorBlock.simpleCodec(FluidGeneratorBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public FluidGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public BlockState rotate(BlockState blockState, @NotNull LevelAccessor level, @NotNull BlockPos blockPos, @NotNull Rotation direction) {
        return (BlockState)blockState.setValue((Property)POWERED, (Comparable)((Boolean)blockState.getValue((Property)POWERED)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{POWERED});
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState newBlockState, boolean isMoving) {
        BlockEntity blockEntity;
        if (blockState.getBlock() != newBlockState.getBlock() && (blockEntity = level.getBlockEntity(blockPos)) instanceof FluidGeneratorBlockEntity) {
            ((FluidGeneratorBlockEntity)blockEntity).drops();
        }
        super.onRemove(blockState, level, blockPos, newBlockState, isMoving);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        FluidGeneratorBlockEntity entity = (FluidGeneratorBlockEntity)level.getBlockEntity(blockPos);
        if (!level.isClientSide()) {
            assert (entity != null);
            if (entity.onPlayerUse(player, InteractionHand.MAIN_HAND)) {
                return InteractionResult.SUCCESS;
            }
            ContainerData data = entity.data;
            player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FluidGeneratorMenu(windowId, playerInventory, blockPos, data), (Component)Component.translatable((String)"block.opolisutilities.fluid_generator")), buf -> buf.writeBlockPos(blockPos));
        }
        return InteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        super.setPlacedBy(level, blockPos, blockState, entity, itemStack);
        if (itemStack.has(ModDataComponents.FLUID_TYPE) && itemStack.has(ModDataComponents.FLUID_AMOUNT)) {
            String fluidAsString = (String)itemStack.get(ModDataComponents.FLUID_TYPE);
            assert (fluidAsString != null);
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString));
            int fluidAmount = (Integer)itemStack.get(ModDataComponents.FLUID_AMOUNT);
            FluidGeneratorBlockEntity fluidGeneratorBlockEntity = (FluidGeneratorBlockEntity)level.getBlockEntity(blockPos);
            fluidGeneratorBlockEntity.setFluid(new FluidStack(fluid, fluidAmount));
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        if (entity instanceof FluidGeneratorBlockEntity) {
            FluidGeneratorBlockEntity fluidGeneratorBlockEntity = (FluidGeneratorBlockEntity)entity;
            if (fluidGeneratorBlockEntity.getFluidStack().getFluid() != Fluids.EMPTY && fluidGeneratorBlockEntity.getFluidStack().getAmount() > 0) {
                ItemStack itemStackWithFluid = new ItemStack((ItemLike)this);
                itemStackWithFluid.set(ModDataComponents.FLUID_TYPE, (Object)fluidGeneratorBlockEntity.getFluidStack().getFluid().getFluidType().toString());
                itemStackWithFluid.set(ModDataComponents.FLUID_AMOUNT, (Object)fluidGeneratorBlockEntity.getFluidStack().getAmount());
                FluidGeneratorBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStackWithFluid);
            } else {
                FluidGeneratorBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)this.asItem().getDefaultInstance());
            }
        }
        super.playerDestroy(level, player, pos, state, entity, stack);
    }

    public void appendHoverText(ItemStack itemStack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            if (itemStack.has(ModDataComponents.FLUID_TYPE)) {
                String fluidAsString = (String)itemStack.get(ModDataComponents.FLUID_TYPE);
                int fluidAmount = (Integer)itemStack.get(ModDataComponents.FLUID_AMOUNT);
                assert (fluidAsString != null);
                FluidType fluid = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString))).getFluidType();
                components.add((Component)Component.literal((String)"Contains: ").append(fluidAmount + "mb ").append((Component)Component.translatable((String)fluid.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltips.blocks.with_fluid.shift").withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(itemStack, context, components, flag);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new FluidGeneratorBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return FluidGeneratorBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.FLUID_GENERATOR_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }
}

