/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.smartcrafting.util;

import com.benbenlaw.smartcrafting.util.SimpleRecipeHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;

public class ClientCraftingRecipeCache {
    public static Map<ResourceLocation, CraftingRecipe> cachedRecipes = new HashMap<ResourceLocation, CraftingRecipe>();

    public static void setRecipes(Map<ResourceLocation, CraftingRecipe> recipes) {
        cachedRecipes = recipes;
    }

    public static CraftingRecipe getRecipe(ResourceLocation id) {
        return cachedRecipes.get(id);
    }

    public static SimpleRecipeHolder getRecipeHolder(ResourceLocation id) {
        CraftingRecipe recipe = cachedRecipes.get(id);
        if (recipe == null) {
            return null;
        }
        return new SimpleRecipeHolder(id, recipe);
    }

    public static List<SimpleRecipeHolder> getRecipeHolders() {
        return cachedRecipes.entrySet().stream().map(entry -> new SimpleRecipeHolder((ResourceLocation)entry.getKey(), (CraftingRecipe)entry.getValue())).collect(Collectors.toList());
    }
}

