/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.smartcrafting;

import com.benbenlaw.smartcrafting.block.SmartCraftingBlocks;
import com.benbenlaw.smartcrafting.config.SmartCraftingConfig;
import com.benbenlaw.smartcrafting.item.SmartCraftingItems;
import com.benbenlaw.smartcrafting.networking.SmartCraftingMessages;
import com.benbenlaw.smartcrafting.screen.SmartCraftingMenus;
import com.benbenlaw.smartcrafting.screen.SmartCraftingScreen;
import com.benbenlaw.smartcrafting.util.KeyBinds;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="smartcrafting")
public class SmartCrafting {
    public static final String MOD_ID = "smartcrafting";
    public static final Logger LOGGER = LogManager.getLogger();
    private BuildCreativeModeTabContentsEvent event;

    public SmartCrafting(IEventBus eventBus, ModContainer modContainer) {
        SmartCraftingItems.ITEMS.register(eventBus);
        SmartCraftingBlocks.BLOCKS.register(eventBus);
        SmartCraftingMenus.MENUS.register(eventBus);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::addCreativeTabContents);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)SmartCraftingConfig.SPEC, "bbl/smartcrafting.toml");
    }

    public void commonSetup(RegisterPayloadHandlersEvent event) {
        SmartCraftingMessages.registerNetworking(event);
    }

    public void addCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            ItemStack craftingTable = event.getParentEntries().stream().filter(stack -> stack.getItem() == Items.CRAFTING_TABLE).findFirst().orElse(null);
            if (craftingTable != null) {
                ItemStack smartCraftingTable = new ItemStack((ItemLike)SmartCraftingBlocks.SMART_CRAFTING_TABLE.get());
                event.insertAfter(craftingTable, smartCraftingTable, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            } else {
                event.accept(new ItemStack((ItemLike)SmartCraftingBlocks.SMART_CRAFTING_TABLE.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(new ItemStack((ItemLike)SmartCraftingItems.PORTABLE_SMART_CRAFTING_TABLE.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @EventBusSubscriber(modid="smartcrafting", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)SmartCraftingMenus.SMART_CRAFTING_MENU.get(), SmartCraftingScreen::new);
        }

        @SubscribeEvent
        public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
            event.register(KeyBinds.OPEN_SMART_CRAFTING_MENU_HOTKEY);
        }
    }
}

