/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.client.render.IClientHighlightHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.network.RequestItemHighlightsPayload;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;
import net.p3pp3rf1y.sophisticatedcore.util.IDoubleBlock;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class ItemInStorageHighlightRenderer {
    public static final int HIGHLIGHT_DURATION = 40;
    public static final int HIGHLIGHT_RANGE = 32;
    public static final int MATCHING_STACK_HIGHLIGHT_COLOR = 5025616;
    public static final int MATCHING_ITEM_HIGHLIGHT_COLOR = 4367861;
    private static List<BlockPos> highlightedStackPositions = Collections.emptyList();
    private static List<BlockPos> highlightedItemPositions = Collections.emptyList();
    private static List<BlockPos> highlightedEmptyTargetPositions = Collections.emptyList();
    private static long highlightExpireTime = 0L;
    @Nullable
    private static List<HighlightedBlock> cachedMatchingStackHighlights = null;
    @Nullable
    private static List<HighlightedBlock> cachedMatchingItemHighlights = null;
    @Nullable
    private static List<HighlightedBlock> cachedEmptyTargetHighlights = null;
    private static List<IClientHighlightHandler<?>> highlightHandlers = new ArrayList();

    public static void registerHighlightHandler(IClientHighlightHandler<?> highlightHandler) {
        highlightHandlers.add(highlightHandler);
    }

    public static void highlightItem(LocalPlayer player, ItemStack stack) {
        List<BlockPos> positions = WorldHelper.getBlockEntitiesInRange(player.level(), player.blockPosition(), 32, IControllableStorage.class).stream().map(IControllerBoundable::getStorageBlockPos).toList();
        LinkedHashMap<ResourceLocation, Object> extras = new LinkedHashMap<ResourceLocation, Object>();
        highlightHandlers.forEach(h -> h.buildClientRequestData((Player)player).ifPresent(data -> extras.put(h.getPayloadHandlerId(), data)));
        if (!positions.isEmpty() || !extras.isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RequestItemHighlightsPayload(stack, positions, extras), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            player.displayClientMessage((Component)TranslationHelper.INSTANCE.translStatusMessage("no_storage_in_range", new Object[0]).setStyle(Style.EMPTY.withColor(0xFF5555)), true);
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 1.0f, 0.45f + RandHelper.getRandomMinusOneToOne(player.level().random) * 0.1f);
        }
    }

    public static void setHighlightedPositions(List<BlockPos> stackPositions, List<BlockPos> itemPositions, List<BlockPos> emptyTargetPositions) {
        highlightedStackPositions = stackPositions;
        highlightedItemPositions = itemPositions;
        highlightedEmptyTargetPositions = emptyTargetPositions;
        highlightExpireTime = Minecraft.getInstance().level.getGameTime() + 40L;
        cachedMatchingStackHighlights = null;
        cachedMatchingItemHighlights = null;
        cachedEmptyTargetHighlights = null;
    }

    public static void render(PoseStack poseStack, float partialTick, Vec3 cameraPos) {
        Minecraft mc = Minecraft.getInstance();
        if (highlightExpireTime < mc.level.getGameTime()) {
            if (!(highlightedStackPositions.isEmpty() && highlightedItemPositions.isEmpty() && highlightedEmptyTargetPositions.isEmpty())) {
                highlightedStackPositions = Collections.emptyList();
                highlightedItemPositions = Collections.emptyList();
                highlightedEmptyTargetPositions = Collections.emptyList();
                cachedMatchingStackHighlights = null;
                cachedMatchingItemHighlights = null;
                cachedEmptyTargetHighlights = null;
                highlightHandlers.forEach(IClientHighlightHandler::clearCache);
            }
            return;
        }
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        if (cachedMatchingStackHighlights == null) {
            cachedMatchingStackHighlights = highlightedStackPositions.stream().map(pos -> ItemInStorageHighlightRenderer.getHighlightedBlock(mc, pos)).toList();
        }
        if (cachedMatchingItemHighlights == null) {
            cachedMatchingItemHighlights = highlightedItemPositions.stream().map(pos -> ItemInStorageHighlightRenderer.getHighlightedBlock(mc, pos)).toList();
        }
        if (cachedEmptyTargetHighlights == null) {
            cachedEmptyTargetHighlights = highlightedEmptyTargetPositions.stream().map(pos -> ItemInStorageHighlightRenderer.getHighlightedBlock(mc, pos)).toList();
        }
        cachedMatchingStackHighlights.forEach(bh -> ItemInStorageHighlightRenderer.renderHighlightedBlock(poseStack, partialTick, cameraPos, bh, mc, buffer, 5025616));
        cachedMatchingItemHighlights.forEach(bh -> ItemInStorageHighlightRenderer.renderHighlightedBlock(poseStack, partialTick, cameraPos, bh, mc, buffer, 4367861));
        cachedEmptyTargetHighlights.forEach(bh -> ItemInStorageHighlightRenderer.renderHighlightedBlock(poseStack, partialTick, cameraPos, bh, mc, buffer, 16771899));
        highlightHandlers.forEach(callback -> callback.render(poseStack, partialTick, cameraPos));
    }

    private static void renderHighlightedBlock(PoseStack poseStack, float partialTick, Vec3 cameraPos, HighlightedBlock bh, Minecraft mc, MultiBufferSource.BufferSource buffer, int color) {
        poseStack.pushPose();
        poseStack.translate((double)bh.pos.getX() - cameraPos.x(), (double)bh.pos.getY() - cameraPos.y(), (double)bh.pos.getZ() - cameraPos.z());
        poseStack.translate(bh.pivot.x, bh.pivot.y, bh.pivot.z);
        float scale = 1.0f + Easing.EASE_IN_OUT_CUBIC.ease((float)ItemInStorageHighlightRenderer.tri01(mc.level.getGameTime(), 15.0, partialTick)) * 0.05f;
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-bh.pivot.x, -bh.pivot.y, -bh.pivot.z);
        BlockHighlightRenderHelper.renderThickEdges(poseStack, (MultiBufferSource)buffer, color, bh.edges(), bh.pos().getX(), bh.pos().getY(), bh.pos().getZ());
        poseStack.popPose();
    }

    private static HighlightedBlock getHighlightedBlock(Minecraft mc, BlockPos pos) {
        ClientLevel level = mc.level;
        BlockState state = level.getBlockState(pos);
        VoxelShape shape = state.getShape((BlockGetter)level, pos);
        Block block = state.getBlock();
        if (block instanceof IDoubleBlock) {
            IDoubleBlock doubleBlock = (IDoubleBlock)block;
            VoxelShape finalShape = shape;
            shape = doubleBlock.getOtherPosition(state, pos).map(otherPos -> {
                BlockState otherState = level.getBlockState(otherPos);
                VoxelShape otherShape = otherState.getShape((BlockGetter)level, otherPos);
                otherShape = otherShape.move((double)(otherPos.getX() - pos.getX()), (double)(otherPos.getY() - pos.getY()), (double)(otherPos.getZ() - pos.getZ()));
                return Shapes.join((VoxelShape)finalShape, (VoxelShape)otherShape, (BooleanOp)BooleanOp.OR);
            }).orElse(shape);
        }
        return new HighlightedBlock(pos, VoxelOutliner.linesFromVoxelShapeSimplified(shape, pos), shape.bounds().getCenter());
    }

    public static double tri01(double ticks, double periodTicks, double phaseOffsetTicks) {
        if (periodTicks <= 0.0) {
            return 0.0;
        }
        double phase = (ticks + phaseOffsetTicks) % periodTicks / (periodTicks - 1.0);
        return 1.0 - Math.abs(2.0 * phase - 1.0);
    }

    private record HighlightedBlock(BlockPos pos, List<VoxelOutliner.Edge> edges, Vec3 pivot) {
    }
}

