/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.herbsandharvest.block.special.basket;

import com.mamailes.herbsandharvest.block.base.HorizontalBaseBlock;
import com.mamailes.herbsandharvest.init.MHHBlocks;
import com.mamailes.herbsandharvest.init.MHHItems;
import com.mamailes.herbsandharvest.tags.MHHTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ProduceBasketCabbage
extends HorizontalBaseBlock {
    public static IntegerProperty COUNT = IntegerProperty.create((String)"count", (int)0, (int)8);
    protected static final VoxelShape BASKET_WEST_AABB = Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)5.0, (double)14.0);
    protected static final VoxelShape BASKET_EAST_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)15.0, (double)5.0, (double)14.0);
    protected static final VoxelShape BASKET_NORTH_AABB = Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)5.0, (double)15.0);
    protected static final VoxelShape BASKET_SOUTH_AABB = Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)5.0, (double)15.0);

    public ProduceBasketCabbage(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COUNT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        switch ((Direction)state.getValue((Property)DIRECTION)) {
            case SOUTH: {
                return BASKET_SOUTH_AABB;
            }
            default: {
                return BASKET_NORTH_AABB;
            }
            case WEST: {
                return BASKET_WEST_AABB;
            }
            case EAST: 
        }
        return BASKET_EAST_AABB;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        boolean validCount;
        ItemStack produce = player.getItemInHand(hand);
        Item item = stack.getItem();
        boolean bl = validCount = (Integer)state.getValue((Property)COUNT) > 0 && (Integer)state.getValue((Property)COUNT) < 8;
        if (!level.isClientSide && validCount) {
            if (produce.is(MHHTags.Items.PRODUCE)) {
                if (produce.getItem() == ProduceBasketCabbage.getProduceItem(item)) {
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)COUNT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)COUNT) + 1)));
                    produce.shrink(1);
                    return ItemInteractionResult.SUCCESS;
                }
            }
            if ((Integer)state.getValue((Property)COUNT) > 8) {
                return ItemInteractionResult.FAIL;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult pHitResult) {
        Item item = null;
        if (!level.isClientSide() && (Integer)state.getValue((Property)COUNT) > 1) {
            player.addItem(new ItemStack((ItemLike)ProduceBasketCabbage.getProduceItem(item)));
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)COUNT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)COUNT) - 1)));
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide && (Integer)state.getValue((Property)COUNT) == 1) {
            player.addItem(new ItemStack((ItemLike)ProduceBasketCabbage.getProduceItem(item)));
            level.setBlockAndUpdate(pos, (BlockState)((Block)MHHBlocks.EMPTY_BASKET.get()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Item item = null;
        int count = (Integer)state.getValue((Property)COUNT);
        ProduceBasketCabbage.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ProduceBasketCabbage.getProduceItem(item), count));
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public static Item getProduceItem(Item item) {
        return (Item)MHHItems.CABBAGE.get();
    }
}

