/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record SizedIngredientChanceResult(SizedIngredient output, float chance) {
    public static final SizedIngredientChanceResult EMPTY = new SizedIngredientChanceResult(new SizedIngredient(Ingredient.EMPTY, 1), 1.0f);
    public static final Codec<SizedIngredientChanceResult> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SizedIngredient.FLAT_CODEC.fieldOf("ingredient").forGetter(SizedIngredientChanceResult::output), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(SizedIngredientChanceResult::chance)).apply((Applicative)inst, SizedIngredientChanceResult::new));

    public ItemStack rollOutput(RandomSource rand) {
        int outputAmount = this.output.count();
        for (int roll = 0; roll < this.output.count(); ++roll) {
            if (!(rand.nextFloat() > this.chance)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack out = this.output.getItems()[0].copy();
        out.setCount(outputAmount);
        return out;
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)this.output);
        buffer.writeFloat(this.chance());
    }

    public static SizedIngredientChanceResult read(RegistryFriendlyByteBuf buffer) {
        return new SizedIngredientChanceResult((SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer), buffer.readFloat());
    }
}

