/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.renderer;

import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.renderer.ResourceFishPatternLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ColorableHierarchicalModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.TropicalFishModelA;
import net.minecraft.client.model.TropicalFishModelB;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ResourceFishRenderer
extends MobRenderer<ResourceFishEntity, ColorableHierarchicalModel<ResourceFishEntity>> {
    private static final ResourceLocation SMALL_RESOURCE_FISH = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"textures/entity/small_resource_fish.png");
    private static final ResourceLocation LARGE_RESOURCE_FISH = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"textures/entity/large_resource_fish.png");
    private final TropicalFishModelA<ResourceFishEntity> modelSmall;
    private final TropicalFishModelB<ResourceFishEntity> modelLarge;

    public ResourceFishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new TropicalFishModelA(context.bakeLayer(ModelLayers.TROPICAL_FISH_SMALL_PATTERN)), 0.3f);
        this.modelSmall = new TropicalFishModelA(context.bakeLayer(ModelLayers.TROPICAL_FISH_SMALL_PATTERN));
        this.modelLarge = new TropicalFishModelB(context.bakeLayer(ModelLayers.TROPICAL_FISH_LARGE_PATTERN));
        this.addLayer(new ResourceFishPatternLayer((RenderLayerParent<ResourceFishEntity, ColorableHierarchicalModel<ResourceFishEntity>>)this, context.getModelSet()));
    }

    @Nullable
    protected RenderType getRenderType(ResourceFishEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity));
    }

    public void render(ResourceFishEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ColorableHierarchicalModel colorableModel;
        this.model = entity.getVariant().pattern().getBase() == ResourceFishEntity.Pattern.Base.SMALL ? this.modelSmall : this.modelLarge;
        int color = entity.getResourceColor();
        EntityModel entityModel = this.model;
        if (entityModel instanceof ColorableHierarchicalModel) {
            colorableModel = (ColorableHierarchicalModel)entityModel;
            colorableModel.setColor(color);
        }
        super.render((LivingEntity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
        entityModel = this.model;
        if (entityModel instanceof ColorableHierarchicalModel) {
            colorableModel = (ColorableHierarchicalModel)entityModel;
            colorableModel.setColor(-1);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(ResourceFishEntity entity) {
        return switch (entity.getVariant().pattern().getBase()) {
            default -> throw new MatchException(null, null);
            case ResourceFishEntity.Pattern.Base.SMALL -> SMALL_RESOURCE_FISH;
            case ResourceFishEntity.Pattern.Base.LARGE -> LARGE_RESOURCE_FISH;
        };
    }

    protected void setupRotations(ResourceFishEntity entity, PoseStack poseStack, float ageInTicks, float rotation, float tick, float headRot) {
        super.setupRotations((LivingEntity)entity, poseStack, ageInTicks, rotation, tick, headRot);
        float f = 4.3f * Mth.sin((float)(0.6f * ageInTicks));
        poseStack.mulPose(Axis.YP.rotationDegrees(f));
        if (!entity.isInWater()) {
            poseStack.translate(0.2f, 0.1f, 0.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

