/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.recipe;

import com.benbenlaw.resourcefish.block.entity.TankControllerBlockEntity;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.recipe.TankRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record FishInfusingRecipe(ResourceLocation fish, NonNullList<SizedIngredient> inputs, int duration, double chance, ResourceLocation createdFish) implements Recipe<RecipeInput>
{
    public boolean matches(RecipeInput container, Level level) {
        boolean hasInfusingUpgrade;
        boolean bl = hasInfusingUpgrade = container.getItem(15).is(ResourceFishItems.INFUSING_UPGRADE) || container.getItem(16).is(ResourceFishItems.INFUSING_UPGRADE) || container.getItem(17).is(ResourceFishItems.INFUSING_UPGRADE) || container.getItem(18).is(ResourceFishItems.INFUSING_UPGRADE);
        if (!hasInfusingUpgrade) {
            return false;
        }
        if (!(container instanceof TankRecipeInput)) {
            return false;
        }
        TankRecipeInput tankInput = (TankRecipeInput)container;
        TankControllerBlockEntity entity = (TankControllerBlockEntity)level.getBlockEntity(tankInput.getPos());
        if (entity == null || entity.fishPool == null || entity.fishPool.isEmpty()) {
            return false;
        }
        boolean fishTypeMatches = false;
        for (ResourceFishEntity fishEntity : entity.fishPool) {
            ResourceLocation typeId = fishEntity.getResourceType().getId();
            if (typeId == null || !typeId.equals((Object)this.fish)) continue;
            fishTypeMatches = true;
            break;
        }
        if (!fishTypeMatches) {
            return false;
        }
        boolean[] usedSlots = new boolean[3];
        for (SizedIngredient ingredient : this.inputs) {
            if (ingredient.ingredient() == Ingredient.EMPTY) continue;
            boolean matched = false;
            for (int slot = 0; slot < 3; ++slot) {
                ItemStack stack;
                if (usedSlots[slot] || !ingredient.test(stack = container.getItem(12 + slot)) || stack.getCount() < ingredient.count()) continue;
                usedSlots[slot] = true;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<FishInfusingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<FishInfusingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("fish").forGetter(FishInfusingRecipe::fish), (App)Codec.list((Codec)SizedIngredient.FLAT_CODEC).fieldOf("inputs").flatXmap(inputs -> {
            if (inputs.size() > 3) {
                return DataResult.error(() -> "Too many inputs for infusing recipe! The maximum quantity of unique results is 3");
            }
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)inputs);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(FishInfusingRecipe::inputs), (App)Codec.INT.fieldOf("duration").forGetter(FishInfusingRecipe::duration), (App)Codec.DOUBLE.fieldOf("chance").forGetter(FishInfusingRecipe::chance), (App)ResourceLocation.CODEC.fieldOf("created_fish").forGetter(FishInfusingRecipe::createdFish)).apply((Applicative)instance, FishInfusingRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, FishInfusingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<FishInfusingRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FishInfusingRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static FishInfusingRecipe read(RegistryFriendlyByteBuf buffer) {
            ResourceLocation fish = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            int inputCount = buffer.readInt();
            NonNullList inputs = NonNullList.create();
            for (int i = 0; i < inputCount; ++i) {
                inputs.add((Object)((SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer)));
            }
            int duration = buffer.readInt();
            double chance = buffer.readDouble();
            ResourceLocation createdFish = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            return new FishInfusingRecipe(fish, (NonNullList<SizedIngredient>)inputs, duration, chance, createdFish);
        }

        private static FishInfusingRecipe write(RegistryFriendlyByteBuf buffer, FishInfusingRecipe recipe) {
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fish);
            buffer.writeInt(recipe.inputs.size());
            for (SizedIngredient input : recipe.inputs) {
                SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)input);
            }
            buffer.writeInt(recipe.duration);
            buffer.writeDouble(recipe.chance);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.createdFish);
            return recipe;
        }
    }

    public static class Type
    implements RecipeType<FishInfusingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

