/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.recipe;

import com.benbenlaw.resourcefish.block.entity.TankControllerBlockEntity;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.recipe.TankRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record FishBreedingRecipe(ResourceLocation parentIngredientA, ResourceLocation parentIngredientB, SizedIngredient breedingIngredient, int duration, double chance, ResourceLocation createdFish) implements Recipe<RecipeInput>
{
    public boolean matches(RecipeInput container, Level level) {
        boolean hasBreedingUpgrade;
        ItemStack upgradeSlot1 = container.getItem(15);
        ItemStack upgradeSlot2 = container.getItem(16);
        ItemStack upgradeSlot3 = container.getItem(17);
        ItemStack upgradeSlot4 = container.getItem(18);
        boolean bl = hasBreedingUpgrade = upgradeSlot1.is(ResourceFishItems.BREEDING_UPGRADE) || upgradeSlot2.is(ResourceFishItems.BREEDING_UPGRADE) || upgradeSlot3.is(ResourceFishItems.BREEDING_UPGRADE) || upgradeSlot4.is(ResourceFishItems.BREEDING_UPGRADE);
        if (container instanceof TankRecipeInput) {
            TankRecipeInput tankRecipeInput = (TankRecipeInput)container;
            TankControllerBlockEntity entity = (TankControllerBlockEntity)level.getBlockEntity(tankRecipeInput.getPos());
            if (entity.fishPool != null && hasBreedingUpgrade) {
                boolean hasBreedingItem;
                Map<ResourceLocation, Long> fishCounts = entity.fishPool.stream().filter(fish -> fish.getResourceType().getId() != null).collect(Collectors.groupingBy(fish -> fish.getResourceType().getId(), Collectors.counting()));
                if (fishCounts.isEmpty()) {
                    return false;
                }
                boolean bl2 = hasBreedingItem = this.breedingIngredient.test(container.getItem(12)) || this.breedingIngredient.test(container.getItem(13)) || this.breedingIngredient.test(container.getItem(14));
                if (!hasBreedingItem) {
                    return false;
                }
                if (this.parentIngredientA.equals((Object)this.parentIngredientB)) {
                    return fishCounts.getOrDefault(this.parentIngredientA, 0L) >= 2L;
                }
                return fishCounts.containsKey(this.parentIngredientA) && fishCounts.containsKey(this.parentIngredientB);
            }
        }
        return false;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<FishBreedingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<FishBreedingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("parent_a").forGetter(FishBreedingRecipe::parentIngredientA), (App)ResourceLocation.CODEC.fieldOf("parent_b").forGetter(FishBreedingRecipe::parentIngredientB), (App)SizedIngredient.FLAT_CODEC.fieldOf("breeding_ingredient").forGetter(FishBreedingRecipe::breedingIngredient), (App)Codec.INT.fieldOf("duration").forGetter(FishBreedingRecipe::duration), (App)Codec.DOUBLE.fieldOf("chance").forGetter(FishBreedingRecipe::chance), (App)ResourceLocation.CODEC.fieldOf("created_fish").forGetter(FishBreedingRecipe::createdFish)).apply((Applicative)instance, FishBreedingRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, FishBreedingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<FishBreedingRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FishBreedingRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static FishBreedingRecipe read(RegistryFriendlyByteBuf buffer) {
            ResourceLocation parentA = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            ResourceLocation parentB = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            SizedIngredient breedingItem = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            int duration = buffer.readInt();
            double chance = buffer.readDouble();
            ResourceLocation createdFish = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            return new FishBreedingRecipe(parentA, parentB, breedingItem, duration, chance, createdFish);
        }

        private static FishBreedingRecipe write(RegistryFriendlyByteBuf buffer, FishBreedingRecipe recipe) {
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.parentIngredientA);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.parentIngredientB);
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.breedingIngredient);
            buffer.writeInt(recipe.duration);
            buffer.writeDouble(recipe.chance);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.createdFish);
            return recipe;
        }
    }

    public static class Type
    implements RecipeType<FishBreedingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

