/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.item;

import com.benbenlaw.resourcefish.entities.ResourceFishEntities;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.item.ResourceFishDataComponents;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.util.ResourceType;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;

public class ResourceFishSpawnEgg
extends DeferredSpawnEggItem {
    public ResourceFishSpawnEgg(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor, Item.Properties props) {
        super(type, backgroundColor, highlightColor, props);
    }

    public InteractionResult useOn(UseOnContext context) {
        ResourceLocation resourceLocation;
        ResourceFishEntity fish;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        BlockPos blockPos = context.getClickedPos();
        if (!level.isClientSide() && (fish = (ResourceFishEntity)ResourceFishEntities.RESOURCE_FISH.get().create(level)) != null && (resourceLocation = (ResourceLocation)itemStack.get((DataComponentType)ResourceFishDataComponents.FISH_TYPE.get())) != null) {
            fish.setResourceType(ResourceType.get(resourceLocation));
            ResourceFishEntity.Variant variant = ResourceFishEntity.generateVariant(ResourceType.get(resourceLocation), level.getRandom());
            fish.setVariant(variant);
            Direction direction = context.getClickedFace();
            BlockPos spawnPos = blockPos.relative(direction, 1);
            fish.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 0.5, (double)spawnPos.getZ() + 0.5);
            level.addFreshEntity((Entity)fish);
            itemStack.shrink(1);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            level.gameEvent((Entity)fish, (Holder)GameEvent.ENTITY_PLACE, blockPos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        BlockHitResult hitResult = ResourceFishSpawnEgg.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = hitResult.getBlockPos();
        Direction clickedFace = hitResult.getDirection();
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean clickedBlockIsLiquid = level.getBlockState(blockPos).getBlock() instanceof LiquidBlock;
        BlockPos spawnPos = clickedBlockIsLiquid ? blockPos : blockPos.relative(clickedFace, 1);
        ResourceFishEntity fish = (ResourceFishEntity)ResourceFishEntities.RESOURCE_FISH.get().create(level);
        if (fish == null) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        ResourceLocation resourceLocation = (ResourceLocation)itemStack.get((DataComponentType)ResourceFishDataComponents.FISH_TYPE.get());
        if (resourceLocation == null) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        ResourceType resourceType = ResourceType.get(resourceLocation);
        fish.setResourceType(resourceType);
        ResourceFishEntity.Variant variant = ResourceFishEntity.generateVariant(resourceType, level.getRandom());
        fish.setVariant(variant);
        fish.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 0.5, (double)spawnPos.getZ() + 0.5);
        level.addFreshEntity((Entity)fish);
        if (!player.isCreative()) {
            itemStack.shrink(1);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, spawnPos);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public Component getName(ItemStack stack) {
        ResourceLocation resourceType = (ResourceLocation)stack.get((DataComponentType)ResourceFishDataComponents.FISH_TYPE.get());
        if (resourceType != null) {
            String name = resourceType.getPath();
            CharSequence[] parts = name.split("_");
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].isEmpty()) continue;
                parts[i] = ((String)parts[i]).substring(0, 1).toUpperCase() + ((String)parts[i]).substring(1);
            }
            String formattedName = String.join((CharSequence)" ", parts);
            return Component.translatable((String)"item.resourcefish.resource_fish_spawn_egg", (Object[])new Object[]{formattedName});
        }
        return super.getName(stack);
    }

    public boolean spawnsEntity(ItemStack stack, EntityType<?> entityType) {
        return super.spawnsEntity(stack, EntityType.BAT);
    }

    public static ItemStack createResourceFishSpawnEgg(ResourceType resourceType) {
        ItemStack stack = new ItemStack((ItemLike)ResourceFishItems.RESOURCE_FISH_SPAWN_EGG.get());
        stack.set(ResourceFishDataComponents.FISH_TYPE, (Object)Objects.requireNonNull(resourceType.getId()));
        return stack;
    }
}

