/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.item;

import com.benbenlaw.resourcefish.item.ResourceFishDataComponents;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CaviarItem
extends Item {
    public CaviarItem(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack stack) {
        ResourceLocation resourceType = (ResourceLocation)stack.get((DataComponentType)ResourceFishDataComponents.FISH_TYPE.get());
        if (resourceType != null) {
            CharSequence[] parts = resourceType.getPath().split("_");
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].isEmpty()) continue;
                parts[i] = ((String)parts[i]).substring(0, 1).toUpperCase() + ((String)parts[i]).substring(1);
            }
            String formattedName = String.join((CharSequence)" ", parts);
            MutableComponent baseName = Component.translatable((String)this.getDescriptionId());
            return Component.literal((String)(formattedName + " ")).append((Component)baseName);
        }
        return super.getName(stack);
    }

    public static ItemStack createCaviarStack(String path) {
        ItemStack stack = new ItemStack((ItemLike)ResourceFishItems.CAVIAR.get());
        stack.set(ResourceFishDataComponents.FISH_TYPE, (Object)ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)path));
        return stack;
    }
}

